unit uMain;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources;

type
  TWinForm3 = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    TreeView1: System.Windows.Forms.TreeView;
    PictureBox1: System.Windows.Forms.PictureBox;
    Button1: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure TreeView1_DoubleClick(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    procedure GenerateNodes(Obj: &Object; Node: TreeNode);
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm3))]

implementation

uses uClasses, System.Reflection;

var
  Members: System.Type;
  Field: FieldInfo;
  InternalNode: TreeNode;
  Method: MethodInfo;
  Prop: PropertyInfo;
  ACliente: TCliente;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm3.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TWinForm3));
  Self.TreeView1 := System.Windows.Forms.TreeView.Create;
  Self.PictureBox1 := System.Windows.Forms.PictureBox.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // TreeView1
  // 
  Self.TreeView1.ImageIndex := -1;
  Self.TreeView1.Location := System.Drawing.Point.Create(11, 14);
  Self.TreeView1.Name := 'TreeView1';
  Self.TreeView1.SelectedImageIndex := -1;
  Self.TreeView1.Size := System.Drawing.Size.Create(264, 296);
  Self.TreeView1.TabIndex := 1;
  Include(Self.TreeView1.DoubleClick, Self.TreeView1_DoubleClick);
  // 
  // PictureBox1
  // 
  Self.PictureBox1.Image := (System.Drawing.Image(resources.GetObject('Pictu' +
    'reBox1.Image')));
  Self.PictureBox1.Location := System.Drawing.Point.Create(8, 320);
  Self.PictureBox1.Name := 'PictureBox1';
  Self.PictureBox1.Size := System.Drawing.Size.Create(144, 32);
  Self.PictureBox1.SizeMode := System.Windows.Forms.PictureBoxSizeMode.StretchImage;
  Self.PictureBox1.TabIndex := 2;
  Self.PictureBox1.TabStop := False;
  // 
  // Button1
  // 
  Self.Button1.BackColor := System.Drawing.SystemColors.ScrollBar;
  Self.Button1.Location := System.Drawing.Point.Create(264, 336);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 3;
  Self.Button1.Text := 'Criar';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // TWinForm3
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.BackColor := System.Drawing.Color.White;
  Self.ClientSize := System.Drawing.Size.Create(352, 366);
  Self.Controls.Add(Self.Button1);
  Self.Controls.Add(Self.PictureBox1);
  Self.Controls.Add(Self.TreeView1);
  Self.Name := 'TWinForm3';
  Self.Text := '.NET Reflection!';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm3.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm3.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm3.TreeView1_DoubleClick(sender: System.Object; e: System.EventArgs);
begin
  MessageBox.Show(
    ACliente.GetType.GetMethod
    (TreeView1.SelectedNode.Text).Invoke(ACliente,[]).ToString);
end;

procedure TWinForm3.GenerateNodes(Obj: &Object; Node: TreeNode);
begin
  Members := Obj.GetType;
  if Assigned(Node) then
    InternalNode := Node
  else
    InternalNode := TreeView1.Nodes.Add(Obj.ClassName);

  with InternalNode.Nodes.Add('Campos') do
    for Field in Members.GetFields do
      Nodes.Add(Field.Name);
  with InternalNode.Nodes.Add('Mtodos') do
    for Method in Members.GetMethods do
      Nodes.Add(Method.Name);
  with InternalNode.Nodes.Add('Propriedades') do
    for Prop in Members.GetProperties do
      if Prop.PropertyType = TypeInfo(TEndereco) then
        GenerateNodes(Prop.GetValue(ACliente,[]), Nodes.Add(Prop.Name))
      else
        Nodes.Add(Prop.Name);
end;

procedure TWinForm3.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  ACliente := TCliente.Create;
  GenerateNodes(ACliente, nil);
end;

end.
