unit EcoSpaceProvider;

interface

uses
  Borland.Eco.Handles,
  Borland.Eco.Web,
  WebServiceApplication1EcoSpace;

const
  // ToDo: Configure the strategy for the provider by changing the constant
  MODE: EcoSpaceStrategyHandler.SessionStateMode = EcoSpaceStrategyHandler.SessionStateMode.IfDirty;
   
type
  TEcoSpaceProvider = class
  public
		class function GetEcoSpace: TWebServiceApplication1EcoSpace; static;
    class procedure ReturnEcoSpace(aEcoSpace: EcoSpace); static;
		class function GetSessionFreeEcoSpace: TWebServiceApplication1EcoSpace; static;
    class procedure ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace); static;
    class procedure ClearSessionState; static;
  end;

implementation

// Utility methods

function GetHandler: EcoSpaceStrategyHandler;
begin
  Result := EcoSpaceStrategyHandler.Create(MODE, typeof(TWebServiceApplication1EcoSpace));
end;

{ TEcoSpaceProvider }

class procedure TEcoSpaceProvider.ClearSessionState;
begin
  GetHandler.ClearSessionState;
end;

class function TEcoSpaceProvider.GetEcoSpace(): TWebServiceApplication1EcoSpace;
begin
  Result := TWebServiceApplication1EcoSpace(GetHandler.GetEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnEcoSpace(aEcoSpace);
end;

class function TEcoSpaceProvider.GetSessionFreeEcoSpace(): TWebServiceApplication1EcoSpace;
begin
  Result := TWebServiceApplication1EcoSpace(GetHandler.GetSessionFreeEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnSessionFreeEcoSpace(aEcoSpace);
end;

end.
