unit Package_1Unit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Cliente = class;
  Endereco = class;
  [UmlElement('Package', Id='BC97CB7A-886D-43FC-947B-1A3C9BFE8DAB')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Cliente))]
  [UmlMetaAttribute('ownedElement', TypeOf(Endereco))]
  Package_1 = class
  public
  type
    [UmlElement('Association', Id='93dbe24d-2ebe-4d47-b235-12d5cb566897')]
    ClienteClienteEnderecoEndereco = class
    end;
  end;

  [assembly: RuntimeRequired(TypeOf(Package_1))]
  IClienteList = interface;
  
  [UmlCollection(TypeOf(Cliente))]
  IClienteList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Cliente;
    procedure set_Item(index: Integer; Value: Cliente);
    property Item[index: Integer]: Cliente read get_Item write set_Item; default;
    function Add(value: Cliente): Integer;
    function Contains(value: Cliente): Boolean;
    function IndexOf(value: Cliente): Integer;
    procedure Insert(index: Integer; value: Cliente);
    procedure Remove(value: Cliente);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='4eed98bf-a44a-41f6-b88b-cdd6209810be')]
  Cliente = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      Nome = Eco_FirstMember;
    const
      Celular = (Eco_LoopbackIndices.Nome + 1);
    const
      Email = (Eco_LoopbackIndices.Celular + 1);
    const
      Endereco = (Eco_LoopbackIndices.Email + 1);
    end;

    ClienteListAdapter = class(ObjectListAdapter, IClienteList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Cliente;
      procedure set_Item(index: Integer; Value: Cliente);
      property Item[index: Integer]: Cliente read get_Item write set_Item; default;
      function Add(value: Cliente): Integer;
      function Contains(value: Cliente): Boolean;
      function IndexOf(value: Cliente): Integer;
      procedure Insert(index: Integer; value: Cliente);
      procedure Remove(value: Cliente);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Nome: string;
    procedure set_Nome(Value: string);
    [UmlElement(Id='16eabf38-bbd1-4f67-99e7-15985b5b27b4', Index=Eco_LoopbackIndices.Nome)]
    property Nome: string read get_Nome write set_Nome;
    function get_Email: string;
    procedure set_Email(Value: string);
    [UmlElement(Id='5f659de3-e102-4760-be47-d4073a1975de', Index=Eco_LoopbackIndices.Email)]
    property Email: string read get_Email write set_Email;
    function get_Celular: Integer;
    procedure set_Celular(Value: Integer);
    [UmlElement(Id='2b2c5938-3860-4937-bee1-dffd47f3d21e', Index=Eco_LoopbackIndices.Celular)]
    property Celular: Integer read get_Celular write set_Celular;
    function get_Endereco: Endereco;
    procedure set_Endereco(Value: Endereco);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Endereco, Id=('52' + 'c' +
    '7a02b-7724-405a-bc24-582a1f6107f7'))]
    [UmlMetaAttribute('association', TypeOf(Package_1.ClienteClienteEnderecoEndereco), Index=1)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Endereco: Endereco read get_Endereco write set_Endereco;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  IEnderecoList = interface;
  
  [UmlCollection(TypeOf(Endereco))]
  IEnderecoList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Endereco;
    procedure set_Item(index: Integer; Value: Endereco);
    property Item[index: Integer]: Endereco read get_Item write set_Item; default;
    function Add(value: Endereco): Integer;
    function Contains(value: Endereco): Boolean;
    function IndexOf(value: Endereco): Integer;
    procedure Insert(index: Integer; value: Endereco);
    procedure Remove(value: Endereco);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='724d8bf4-473c-4756-b082-d90f129d7cb4')]
  Endereco = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      Logradouro = Eco_FirstMember;
    const
      Complemento = (Eco_LoopbackIndices.Logradouro + 1);
    const
      Numero = (Eco_LoopbackIndices.Complemento + 1);
    const
      Cliente = (Eco_LoopbackIndices.Numero + 1);
    end;

    EnderecoListAdapter = class(ObjectListAdapter, IEnderecoList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Endereco;
      procedure set_Item(index: Integer; Value: Endereco);
      property Item[index: Integer]: Endereco read get_Item write set_Item; default;
      function Add(value: Endereco): Integer;
      function Contains(value: Endereco): Boolean;
      function IndexOf(value: Endereco): Integer;
      procedure Insert(index: Integer; value: Endereco);
      procedure Remove(value: Endereco);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Cliente: Cliente;
    procedure set_Cliente(Value: Cliente);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Cliente, Id='5814ef7b' +
    '-def4-43bc-ad3a-f2f90142fd4c')]
    [UmlMetaAttribute('association', TypeOf(Package_1.ClienteClienteEnderecoEndereco), Index=0)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Cliente: Cliente read get_Cliente write set_Cliente;
    function get_Logradouro: string;
    procedure set_Logradouro(Value: string);
    [UmlElement(Id='a0b6d494-c0bb-45b1-b151-a8022adefee9', Index=Eco_LoopbackIndices.Logradouro)]
    property Logradouro: string read get_Logradouro write set_Logradouro;
    function get_Numero: string;
    procedure set_Numero(Value: string);
    [UmlElement(Id='bedde461-a177-41c2-b0cd-c00875f0e400', Index=Eco_LoopbackIndices.Numero)]
    property Numero: string read get_Numero write set_Numero;
    function get_Complemento: string;
    procedure set_Complemento(Value: string);
    [UmlElement(Id='b0a3f6ec-7478-43fe-a9ea-e036109ba110', Index=Eco_LoopbackIndices.Complemento)]
    property Complemento: string read get_Complemento write set_Complemento;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

function Cliente.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Cliente.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Cliente.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Cliente.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Cliente.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Cliente.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Cliente.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Cliente.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Cliente.get_Endereco: Endereco;
begin
  Result := (Package_1Unit.Endereco(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Endereco)));
end;

procedure Cliente.set_Endereco(Value: Endereco);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Endereco, (System.Object(Value)));
end;

function Cliente.get_Celular: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Celular)));
end;

procedure Cliente.set_Celular(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Celular, (System.Object(Value)));
end;

function Cliente.get_Email: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Email)));
end;

procedure Cliente.set_Email(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Email, (System.Object(Value)));
end;

function Cliente.get_Nome: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Nome)));
end;

procedure Cliente.set_Nome(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Nome, (System.Object(Value)));
end;

constructor Cliente.ClienteListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Cliente.ClienteListAdapter.get_Item(index: Integer): Cliente;
begin
  Result := (Package_1Unit.Cliente(inherited Adaptee[index]));
end;

procedure Cliente.ClienteListAdapter.set_Item(index: Integer; Value: Cliente);
begin
  inherited Adaptee[index] := value;
end;

function Cliente.ClienteListAdapter.Add(value: Cliente): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Cliente.ClienteListAdapter.Contains(value: Cliente): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Cliente.ClienteListAdapter.IndexOf(value: Cliente): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Cliente.ClienteListAdapter.Insert(index: Integer; value: Cliente);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Cliente.ClienteListAdapter.Remove(value: Cliente);
begin
  Self.Adaptee.Remove(value);
end;

function Endereco.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Endereco.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Endereco.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Endereco.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Endereco.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Endereco.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Endereco.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Endereco.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Endereco.get_Complemento: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Complemento)));
end;

procedure Endereco.set_Complemento(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Complemento, (System.Object(Value)));
end;

function Endereco.get_Numero: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Numero)));
end;

procedure Endereco.set_Numero(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Numero, (System.Object(Value)));
end;

function Endereco.get_Logradouro: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Logradouro)));
end;

procedure Endereco.set_Logradouro(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Logradouro, (System.Object(Value)));
end;

function Endereco.get_Cliente: Cliente;
begin
  Result := (Package_1Unit.Cliente(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Cliente)));
end;

procedure Endereco.set_Cliente(Value: Cliente);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Cliente, (System.Object(Value)));
end;

constructor Endereco.EnderecoListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Endereco.EnderecoListAdapter.get_Item(index: Integer): Endereco;
begin
  Result := (Package_1Unit.Endereco(inherited Adaptee[index]));
end;

procedure Endereco.EnderecoListAdapter.set_Item(index: Integer; Value: Endereco);
begin
  inherited Adaptee[index] := value;
end;

function Endereco.EnderecoListAdapter.Add(value: Endereco): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Endereco.EnderecoListAdapter.Contains(value: Endereco): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Endereco.EnderecoListAdapter.IndexOf(value: Endereco): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Endereco.EnderecoListAdapter.Insert(index: Integer; value: Endereco);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Endereco.EnderecoListAdapter.Remove(value: Endereco);
begin
  Self.Adaptee.Remove(value);
end;

{ Package_1 }


end.
