unit WebService1;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Diagnostics, System.Web,
  System.Web.Services,
  Borland.Eco.ObjectRepresentation, 
  Borland.Eco.Handles, WebServiceApplication1EcoSpace, Package_1Unit;

type
  TWebService1 = class(System.Web.Services.WebService)
  {$REGION 'Designer Managed Code'}
  strict private
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: IContainer;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    fEcoSpace: TWebServiceApplication1EcoSpace;
    function get_EcoSpace: TWebServiceApplication1EcoSpace;
    procedure DoneWithEcoSpace;
    property EcoSpace: TWebServiceApplication1EcoSpace read get_EcoSpace;
  strict protected
    procedure Dispose(disposing: boolean); override;
  {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObjectInstance;
  {$ENDREGION}
  public
    constructor Create;
    (*
    // Sample Web Service Method
    [WebMethod]
    function HelloWorld: string;
    [WebMethod]
    function OrderCount: integer;
    [WebMethod]
    procedure NewOrder(Name: String);
    *)
    [WebMethod(Description='Mtodo de exemplo Web Service!',
            MessageName='SampleModificado')]
    procedure Sample;
    [WebMethod(CacheDuration = 60)]
    function GetCurrentDateTime: DateTime;
    [WebMethod]
    function GetAllClients: DataSet;
    [WebMethod]
    procedure NewClient(Nome, Email: string);
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebService1.InitializeComponent;
begin    
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  //
  // rhRoot
  //
  Self.rhRoot.EcoSpace := nil;
  Self.rhRoot.EcoSpaceType := TypeOf(WebServiceApplication1EcoSpace.TWebServiceApplication1EcoSpace);
  Self.rhRoot.StaticValueTypeName := '';
  Self.rhRoot.Variables := nil;
end;
procedure TWebService1.NewClient(Nome, Email: string);
var
  oCliente: Cliente;
begin
  oCliente := Cliente.Create(EcoSpace);
  oCliente.Nome := Nome;
  oCliente.Email := Email;  
  UpdateDatabase;
  DoneWithEcoSpace;
end;

{$ENDREGION}

constructor TWebService1.Create;
begin
  inherited;
  //
  // Required for Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

{$REGION 'Utility Methods'}
procedure TWebService1.UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function TWebService1.IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function TWebService1.ObjectForId(Id: string): IObjectInstance;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

procedure TWebService1.Sample;
begin

end;

{$ENDREGION}

procedure TWebService1.Dispose(disposing: boolean);
begin
  if disposing and (components <> nil) then
    components.Dispose;
  inherited Dispose(disposing);
end;

function TWebService1.get_EcoSpace: TWebServiceApplication1EcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fecoSpace := TEcoSpaceProvider.GetSessionFreeEcoSpace;
    rhRoot.EcoSpace := fEcoSpace;
    // Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure TWebService1.DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or it's contents here.
  // Otherwise it is not safe to return it to a pool

  TEcoSpaceProvider.ReturnSessionFreeEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

function TWebService1.GetCurrentDateTime: DateTime;
begin
  result := DateTime.Now;
end;

function TWebService1.GetAllClients: DataSet;
var
  OclService: IOclService;
  dt: DataSet;
  Elements: IObjectList;
  Obj: IObject;
  dTable: DataTable;
  dRow: DataRow;
begin
  dt := DataSet.Create;
  OclService := EcoSpace.GetEcoService(TypeOf(IOclService)) as IOclService;
  Elements := OclService.Evaluate('Cliente.AllInstances') as IObjectList;

  dTable := DataTable.Create('tbClientes');
  dt.Tables.Add(dTable);

  dt.Tables[0].Columns.Add('NOME');
  dt.Tables[0].Columns.Add('EMAIL');

  for Obj in Elements do
  begin
    dRow := dt.Tables[0].NewRow;
      dRow['NOME']  := (Obj.AsObject as Cliente).Nome;
      dRow['EMAIL'] := (Obj.AsObject as Cliente).Email;
    dt.Tables[0].Rows.Add(dRow);
  end;

  dt.AcceptChanges;

  result := dt;
end;

(*
// Sample Web Service Methods
// The following method is provided to allow for testing a new web service.
function TWebService1.HelloWorld: string;
begin
  Result := 'Hello World';
end;

// This is a minimal web method reading data,
// It assumes an ECO model containing a Class named Order
function TWebService1.OrderCount: integer;
var
  OclService: IOclService;
  ResultElement: IElement;
begin
  OclService := EcoSpace.GetEcoService(typeof(IOclService)) as IOclService;
  ResultElement := OclService.EvaluateAndSubscribe(nil, 'Order.allInstances->size', nil, nil);
  Result := Integer(ResultElement.AsObject);
  DoneWithEcoSpace;
end;

// This is a minimal web method modifying data
// It assumes an ECO model containing a Class named Order with an attribute Order.CustomerName
procedure TWebService1.NewOrder(Name: String);
var
  anOrder: Order;
begin
  anOrder := Order.Create(EcoSpace);
  anOrder.CustomerName := Name;
  UpdateDatabase;
  DoneWithEcoSpace;
end;
 *)

end.

