unit UManutencao;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, DB, DBClient;

type
  TFrmManutencao = class(TForm)
    Label2: TLabel;
    GroupBox2: TGroupBox;
    BtRefazIndices: TBitBtn;
    CbRefazEstrutura: TCheckBox;
    CbRecomputaEstatistica: TCheckBox;
    PbRefazIndices: TProgressBar;
    sbManutencao: TStatusBar;
    CdsGenerico: TClientDataSet;
    procedure BtRefazIndicesClick(Sender: TObject);
  private
    procedure RefazIndices; stdcall;
  public
    { Public declarations }
  end;

var
  FrmManutencao: TFrmManutencao;

implementation

uses UDM;

{$R *.dfm}

{ TFrmManutencao }

procedure TFrmManutencao.BtRefazIndicesClick(Sender: TObject);
begin
  RefazIndices;
end;

procedure TFrmManutencao.RefazIndices;
var
  aIndices : array[0..500] of String;
  i, j     : Integer;
  sIndices : String;
  sSQL     : String;
begin
  if (not CbRefazEstrutura.Checked) and (not CbRecomputaEstatistica.Checked) then
  begin
    ShowMessage(' necessrio escolher pelo menos uma operao com os ndices');
    Exit;
  end;
  Screen.Cursor := crHourGlass;
  i    := 0;
  j    := 1;
  sSQL := ' select  rdb$indices.rdb$index_name ' +
          '        ,rdb$indices.rdb$relation_name ' +
          '        ,rdb$indices.rdb$index_id ' +
          '        ,rdb$indices.rdb$unique_flag ' +
          '        ,rdb$indices.rdb$segment_count ' +
          '        ,rdb$indices.rdb$foreign_key ' +
          '        ,rdb$indices.rdb$system_flag ' +
          '        ,rdb$indices.rdb$index_inactive ' +
          '        ,rdb$indices.rdb$index_type ' +
          ' from    rdb$indices ' +
          ' where   rdb$indices.rdb$index_name not in (select  rdb$indices.rdb$index_name ' +
          '                                            from    rdb$indices ' +
          '                                            where   rdb$indices.rdb$system_flag = 1) ';
  CdsGenerico.Close;
  CdsGenerico.CommandText := sSQL;
  CdsGenerico.Open;
  PbRefazIndices.Max := CdsGenerico.RecordCount;

  CdsGenerico.First;
  while not CdsGenerico.Eof do
  begin
    PbRefazIndices.Position := j;
    Inc(j);
    if CbRefazEstrutura.Checked then
    begin
      if  (Pos('PK', CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) = 0)
      and (Pos('FK', CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) = 0)
      and (Pos('RDB$', CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) = 0) then
      begin
        sbManutencao.Panels[1].Text := 'ndice ' + Trim(CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) +
                                       ' em Reestruturao';
        if not DM.Principal.AppServer.RunSQL(' ALTER INDEX ' +
                                             CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString +
                                           ' INACTIVE;') then
        begin
          aIndices[i] := Trim(CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) + ' - Desativao';
          inc(i);
        end
        else if not DM.Principal.AppServer.RunSQL(' ALTER INDEX ' +
                                                  CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString +
                                                ' ACTIVE;') then
        begin
          aIndices[i] := Trim(CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) + ' - Ativao';
          inc(i);
        end
      end;
    end;
    if CbRecomputaEstatistica.Checked then
    begin
      sbManutencao.Panels[1].Text := 'ndice ' + Trim(CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) +
                                     ' em Recomputao';
      if not DM.Principal.AppServer.RunSQL(' SET STATISTICS INDEX ' +
                                           CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString + ';') then
      begin
        aIndices[i] := Trim(CdsGenerico.Fields.FieldByName('RDB$INDEX_NAME').AsString) + ' - Recomputao';
        inc(i);
      end
    end;
    Update;
    CdsGenerico.Next;
  end;
  CdsGenerico.Close;

  if i > 0 then
  begin
    for j := 0 to i do
    begin
      sIndices := aIndices[j] + #13;
    end;
    ShowMessage('Erros nos ndices Abaixo:' + #13 + sIndices);
  end;

  Screen.Cursor := crDefault;
  sbManutencao.Panels[1].Text := 'Refaz ndices Terminado';
end;

end.
