unit UPesquisa;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, DB, DBClient, Mask,
  Grids, DBGrids, Tabs;

type
  TFrmPesquisa = class(TForm)
    sbRodape: TStatusBar;
    tiAgora: TTimer;
    DsCDS: TDataSource;
    CDS: TClientDataSet;
    Panel1: TPanel;
    pbOk: TBitBtn;
    Panel2: TPanel;
    pbRetorna: TBitBtn;
    Panel3: TPanel;
    pnFiltro: TPanel;
    ltLocaliza: TLabel;
    btApagaPesquisa: TSpeedButton;
    EdtCodigo: TEdit;
    cbCompleto: TCheckBox;
    edtLocaliza: TMaskEdit;
    Panel5: TPanel;
    btAnterior: TSpeedButton;
    btProximo: TSpeedButton;
    btPrimeiro: TSpeedButton;
    btUltimo: TSpeedButton;
    btAplicaFiltro: TBitBtn;
    anFiltro: TAnimate;
    dbgPrin: TDBGrid;
    tsLetra: TTabSet;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure tiAgoraTimer(Sender: TObject);
    procedure pbRetornaClick(Sender: TObject);
    procedure pbOkClick(Sender: TObject);
    procedure btPrimeiroClick(Sender: TObject);
    procedure btProximoClick(Sender: TObject);
    procedure btAnteriorClick(Sender: TObject);
    procedure btUltimoClick(Sender: TObject);
    procedure btApagaPesquisaClick(Sender: TObject);
    procedure btAplicaFiltroClick(Sender: TObject);
    procedure dbgPrinTitleClick(Column: TColumn);
    procedure CDSAfterOpen(DataSet: TDataSet);
    procedure FormShow(Sender: TObject);
    procedure tsLetraClick(Sender: TObject);
    procedure edtLocalizaKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CDSAfterScroll(DataSet: TDataSet);
    procedure edtLocalizaKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EdtCodigoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure dbgPrinDblClick(Sender: TObject);
    procedure CDSBeforeOpen(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    sOutroFiltro : string;
  end;

var
  FrmPesquisa: TFrmPesquisa;

implementation

uses UDM;

{$R *.dfm}

procedure TFrmPesquisa.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CDS.Close;
  Release;
end;

procedure TFrmPesquisa.tiAgoraTimer(Sender: TObject);
begin
   sbRodape.Panels[0].Text := Copy(DateTimeToStr(Now),1,16);
end;

procedure TFrmPesquisa.pbRetornaClick(Sender: TObject);
begin
  ID := 0;
  NomeDesceicao := '';
  Close;
end;

procedure TFrmPesquisa.pbOkClick(Sender: TObject);
begin
  if CDS.Active and (CDS.RecordCount > 0) then
  begin
    ID   := CDS.Fields[0].AsFloat;
    NomeDesceicao := CDS.Fields[1].AsString;
    CDS.Close;
    Close;
  end
  else
  begin
    ID := 0;
    NomeDesceicao := '';
    CDS.Close;
    Close;
  end;
end;

procedure TFrmPesquisa.btPrimeiroClick(Sender: TObject);
begin
  CDS.First;
end;

procedure TFrmPesquisa.btProximoClick(Sender: TObject);
begin
  CDS.Next;
end;

procedure TFrmPesquisa.btAnteriorClick(Sender: TObject);
begin
  CDS.Prior;
end;

procedure TFrmPesquisa.btUltimoClick(Sender: TObject);
begin
  CDS.Last;
end;

procedure TFrmPesquisa.btApagaPesquisaClick(Sender: TObject);
begin
  EdtCodigo.Text := '';
  edtLocaliza.Text := '';
end;

procedure TFrmPesquisa.btAplicaFiltroClick(Sender: TObject);
var
  sAux : String;
begin
  if EdtCodigo.Visible and (EdtCodigo.Text = '') then exit;

  Screen.Cursor               := crHourGlass;
  btAplicaFiltro.Visible      := False;
  anFiltro.Reset;
  anFiltro.Show;
  anFiltro.Play(anFiltro.StartFrame, anFiltro.StopFrame, 0);

  CDS.Close;
  if EdtCodigo.Visible then
  begin
    CDS.Params[0].AsString    := '-1';
    if CDS.Params.Count > 1 then
      CDS.Params[1].AsFloat   := StrToFloatDef(EdtCodigo.Text, 0)
    else
      CDS.Params[0].AsString  := '%';
  end
  else if edtLocaliza.Visible then
  begin
    if not cbCompleto.Checked then
    begin
      CDS.Params[0].AsString  := edtLocaliza.Text + sAux + '%';
      if CDS.Params.Count > 1 then
        CDS.Params[1].AsFloat := -1;
    end
    else
    begin
      CDS.Params[0].AsString  := '%' + edtLocaliza.Text + sAux + '%';
      if CDS.Params.Count > 1 then
        CDS.Params[1].AsFloat := -1;
    end;
  end;
  CDS.IndexName               := 'DEFAULT_ORDER';
  CDS.Open;

  if CDS.Active and (cds.RecordCount > 0) then
  begin
    pbOk.Default := True;
  end
  else if not CDS.Active or (cds.RecordCount <= 0) then
  begin
    pbOk.Default := False;
  end;

  if not (edtLocaliza.Text = '') and edtLocaliza.Visible then
    sbRodape.Panels[1].Text   := sbRodape.Panels[1].Text+' Descrio -> '+Trim(edtLocaliza.Text)
  else
    sbRodape.Panels[1].Text   := 'Sem Filtro';

  if not (EdtCodigo.Text = '') and EdtCodigo.Visible then
    sbRodape.Panels[1].Text   := sbRodape.Panels[1].Text+' Cdigo -> '+Trim(EdtCodigo.Text)
  else
    sbRodape.Panels[1].Text   := 'Sem Filtro';

  anFiltro.Stop;
  anFiltro.Hide;
  btAplicaFiltro.Visible      := True;
  tsLetra.TabIndex            := 0;

  btAplicaFiltro.Visible      := True;
  if EdtCodigo.Visible then
    dbgPrinTitleClick(dbgPrin.Columns[0])
  else
    dbgPrinTitleClick(dbgPrin.Columns[1]);
  CDS.First;
  if CDS.BOF then
  begin
    if EdtCodigo.Visible then
      EdtCodigo.SetFocus
    else
      edtLocaliza.SetFocus;
  end
  else
  begin
    ActiveControl            := dbgPrin;
    pbOk.Default             := true;
  end;
  Screen.Cursor               := crDefault;
end;

procedure TFrmPesquisa.dbgPrinTitleClick(Column: TColumn);
const
  idxDefault = 'DEFAULT_ORDER';
var
  strColumn : string;
  i : integer;
  bolUsed : boolean;
  idOptions : TIndexOptions;
begin
  if Column.Index = 0 then
    begin
      edtLocaliza.Visible := false;
      EdtCodigo.Visible   := true;
      ltLocaliza.Caption  := 'Cdigo:';
      cbCompleto.Visible  := false;
      cbCompleto.Checked  := false;
      edtLocaliza.Text    := '';
      EdtCodigo.SetFocus;
    end
  else if Column.Index = 1 then
    begin
      edtLocaliza.Visible := true;
      EdtCodigo.Visible   := false;
      ltLocaliza.Caption  := 'Descrio:';
      cbCompleto.Visible  := true;
      EdtCodigo.Text      := '';
      edtLocaliza.SetFocus;
    end;

  strColumn := idxDefault;

  if Column.Field.FieldKind in [fkCalculated, fkLookup, fkAggregate, fkInternalCalc] then Exit;

  if Column.Field.DataType in [ftBlob, ftMemo] then Exit;

  for i := 0 to dbgPrin.Columns.Count -1 do
    dbgPrin.Columns[i].Title.Font.Style := [];

  bolUsed := (Column.Field.FieldName = CDS.IndexName);

  idOptions := [];
  with CDS do
    begin
      IndexDefs.Update;
      for i := 0 to IndexDefs.Count - 1 do
        begin
          if IndexDefs.Items[i].Name = Column.Field.FieldName then
            begin
              strColumn := Column.Field.FieldName;
              case (IndexDefs.Items[i].Options = [ixDescending]) of
                true : idOptions := [];
                false : idOptions := [ixDescending];
              end;
            end;
        end;

    if (strColumn = idxDefault)  or (bolUsed) then
      begin
        if bolUsed then
          DeleteIndex(Column.Field.FieldName);
        try
          AddIndex(Column.Field.FieldName, Column.Field.FieldName, idOptions, '', '', 0);
          strColumn := Column.Field.FieldName;
        except
          if bolUsed then
          strColumn := idxDefault;
        end;
      end;

    try
      IndexName := strColumn;
      Column.Title.Font.Style := [fsbold];
    except
      IndexName := idxDefault;
    end;
  end;
end;

procedure TFrmPesquisa.CDSAfterOpen(DataSet: TDataSet);
begin
  btPrimeiro.Enabled         := (not CDS.Bof) or (not CDS.Eof);
  btProximo.Enabled          := (not CDS.Bof) or (not CDS.Eof);
  btAnterior.Enabled         := (not CDS.Bof) or (not CDS.Eof);
  btUltimo.Enabled           := (not CDS.Bof) or (not CDS.Eof);
end;

procedure TFrmPesquisa.FormShow(Sender: TObject);
begin
  tsLetra.Brush.Color := clSkyBlue;
  sbRodape.Color      := clSkyBlue;
  dbgPrinTitleClick(dbgPrin.Columns[1]);
  ActiveControl := edtLocaliza;
end;

procedure TFrmPesquisa.tsLetraClick(Sender: TObject);
var
   sLetra : string;
begin
  if not edtLocaliza.Visible then
    dbgPrinTitleClick(dbgPrin.Columns[1]);

  CDS.Close;
  sLetra := Copy(tsLetra.Tabs[tsLetra.TabIndex], 2, 1);
  CDS.Params[0].AsString  := sLetra + '%';
  if CDS.Params.Count > 1 then
     CDS.Params[1].AsFloat := -1;
  CDS.IndexName := 'DEFAULT_ORDER';
  CDS.Open;
end;

procedure TFrmPesquisa.dbgPrinDblClick(Sender: TObject);
begin
  pbOkClick(Self);
end;

procedure TFrmPesquisa.edtLocalizaKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = 40) and not(CDS.Eof) then
  begin
    CDS.Next;
    edtLocaliza.SelStart := Length(edtLocaliza.Text);
  end
  else if (key = 38) and not(CDS.Bof) then
  begin
    CDS.Prior;
    edtLocaliza.SelStart := Length(edtLocaliza.Text);
  end;
end;

procedure TFrmPesquisa.CDSAfterScroll(DataSet: TDataSet);
begin
  btProximo.Enabled := True;
  btUltimo.Enabled := True;
  btPrimeiro.Enabled := True;
  btAnterior.Enabled := True;
  if CDS.Eof then
  begin
    btProximo.Enabled := False;
    btUltimo.Enabled := False;
  end;
  if cds.Bof then
  begin
    btPrimeiro.Enabled := False;
    btAnterior.Enabled := False;
  end;
end;

procedure TFrmPesquisa.CDSBeforeOpen(DataSet: TDataSet);
begin
  CDS.IndexName := 'DEFAULT_ORDER';
end;

procedure TFrmPesquisa.edtLocalizaKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_NEXT then
    btAplicaFiltroClick(Self);
end;

procedure TFrmPesquisa.EdtCodigoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_NEXT then
    btAplicaFiltroClick(Self);
end;

end.
