unit UCadastro;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, CodeGearApplicationServer2007_TLB, StdVcl, DB, Provider, SqlExpr,
  MidasLib, FMTBcd;

type
  TClasseCadastro = class(TRemoteDataModule, IClasseCadastro)
    SqlClientes: TSQLDataSet;
    SqlProdutos: TSQLDataSet;
    SqlPedidos: TSQLDataSet;
    SqlItens: TSQLDataSet;
    SqlClientesID_CLIENTE: TFloatField;
    SqlClientesNOME: TStringField;
    SqlClientesCPF: TStringField;
    SqlClientesSTATUS: TStringField;
    SqlClientesENDERECO: TStringField;
    SqlClientesBAIRRO: TStringField;
    SqlClientesCIDADE: TStringField;
    SqlClientesESTADO: TStringField;
    SqlClientesDATACAD: TSQLTimeStampField;
    SqlClientesFOTO: TBlobField;
    DspClientes: TDataSetProvider;
    DspProdutos: TDataSetProvider;
    DspPedidos: TDataSetProvider;
    DspItens: TDataSetProvider;
    SqlProdutosID_PRODUTO: TFloatField;
    SqlProdutosDESCRICAO: TStringField;
    SqlProdutosPRECOCOMPRA: TFloatField;
    SqlProdutosQUANTIDADE: TFloatField;
    SqlPedidosID_PEDIDO: TFloatField;
    SqlPedidosID_CLIENTE: TFloatField;
    SqlPedidosDATAPED: TSQLTimeStampField;
    SqlPedidosNOME: TStringField;
    SqlPedidosCPF: TStringField;
    SqlItensID_PEDIDO: TFloatField;
    SqlItensID_PRODUTO: TFloatField;
    SqlItensQUANTIDADE: TFloatField;
    SqlItensPRECOVENDA: TFloatField;
    SqlItensDESCRICAO: TStringField;
    procedure RemoteDataModuleDestroy(Sender: TObject);
    procedure SqlClientesBeforeOpen(DataSet: TDataSet);
    procedure DspClientesBeforeApplyUpdates(Sender: TObject;
      var OwnerData: OleVariant);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

var
  ClasseCadastro        : TClasseCadastro;
  ClasseCadastroFactory : TComponentFactory;

implementation

uses UPrincipal, UServer;

{$R *.DFM}

procedure TClasseCadastro.DspClientesBeforeApplyUpdates(Sender: TObject;
  var OwnerData: OleVariant);
begin
  if FrmServer = nil then
  begin
    FrmServer := TFrmServer.Create(self);
    ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
  end
  else if ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection = nil then
  begin
    try
      ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    except
      FrmServer := TFrmServer.Create(self);
      ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    end;
  end;
end;

procedure TClasseCadastro.RemoteDataModuleDestroy(Sender: TObject);
var
  i : Integer;
begin
  for i := 0 to ComponentCount -1 do
  begin
    if Components[i] is TSQLConnection then
    begin
      (Components[i] as TSQLConnection).Close;
    end
    else if Components[i] is TSQLDataSet then
    begin
      (Components[i] as TSQLDataSet).Close;
    end
    else if Components[i] is TClientDataSet then
    begin
      (Components[i] as TClientDataSet).Close;
    end;
  end;
end;

procedure TClasseCadastro.SqlClientesBeforeOpen(DataSet: TDataSet);
begin
  if FrmServer = nil then
  begin
    FrmServer := TFrmServer.Create(self);
    (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
  end
  else if (DataSet as TSQLDataSet).SQLConnection = nil then
  begin
    try
      (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    except
      FrmServer := TFrmServer.Create(self);
      (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    end;
  end;
end;

class procedure TClasseCadastro.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  ClasseCadastroFactory := TComponentFactory.Create(ComServer, TClasseCadastro,
    Class_ClasseCadastro, ciMultiInstance, tmSingle);
end.
