unit UPrincipal;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, CodeGearApplicationServer2007_TLB, StdVcl, FMTBcd, DB, Provider, SqlExpr,
  MidasLib, ExtCtrls;

type
  TClassePrincipal = class(TRemoteDataModule, IClassePrincipal)
    SqlControle: TSQLDataSet;
    DspControle: TDataSetProvider;
    CdsControle: TClientDataSet;
    CdsControleCAMPO: TStringField;
    CdsControleVALOR: TFloatField;
    CdsControlaID: TClientDataSet;
    CdsControlaIDCAMPO: TStringField;
    CdsControlaIDVALOR: TFloatField;
    SqlDataHora: TSQLDataSet;
    SqlDataHoraDATA: TDateField;
    SqlDataHoraHORA: TTimeField;
    SqlDataHoraDATAHORA: TSQLTimeStampField;
    SqlConsGenerico: TSQLDataSet;
    DspConsGenerico: TDataSetProvider;
    CdsPedidos: TClientDataSet;
    CdsPedidosID_CLIENTE: TFloatField;
    CdsPedidosDATAPED: TSQLTimeStampField;
    CdsItens: TClientDataSet;
    CdsItensID_PRODUTO: TFloatField;
    CdsItensQUANTIDADE: TFloatField;
    CdsItensPRECOVENDA: TFloatField;
    CdsPedidosID_PEDIDO: TFloatField;
    CDSToken: TClientDataSet;
    CDSTokenToken: TBooleanField;
    Timer1: TTimer;
    procedure RemoteDataModuleCreate(Sender: TObject);
    procedure RemoteDataModuleDestroy(Sender: TObject);
    procedure SqlControleBeforeOpen(DataSet: TDataSet);
    procedure DspControleBeforeApplyUpdates(Sender: TObject;
      var OwnerData: OleVariant);
    procedure Timer1Timer(Sender: TObject);
  private
    bModoProducao   : Boolean;
    bActiveSecurity : Boolean;
    bToken          : Boolean;
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    function RetornaID(var DataIn: OleVariant): OleVariant; safecall;
    function RetornaSQL(var DataIn: OleVariant): OleVariant; safecall;
    function PegaData: OleVariant; safecall;
    function PegaDataHora: OleVariant; safecall;
    function PegaHora: OleVariant; safecall;
    function RunSQL(var DataIn: OleVariant): OleVariant; safecall;
    function Get_ClasseCadastro: IClasseCadastro; safecall;
    function Get_ClasseConsulta: IClasseConsulta; safecall;
    function IncluiPedidos(var Pedidos, Itens: OleVariant): OleVariant; safecall;
    function Get_MinhaClasseSecundaria: IClasseConsulta; safecall;
    function Get_ClasseRelatorios: IClasseRelatorios; safecall;
    procedure SetToken(var DataIn: OleVariant); safecall;
  public
    { Public declarations }
  end;

var
  ClassePrincipal : TClassePrincipal;

implementation

uses UCadastro, UConsulta, UServer, URelatorios;

{$R *.DFM}

class procedure TClassePrincipal.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TClassePrincipal.RemoteDataModuleCreate(Sender: TObject);
begin
  FrmServer.CriaConexao;
  bModoProducao := FrmServer.GetModoProducao;
  if bModoProducao then
    bActiveSecurity := True
  else
    bActiveSecurity := False;
  Timer1.Enabled := True;
end;

procedure TClassePrincipal.RemoteDataModuleDestroy(Sender: TObject);
var
  i : Integer;
begin
  for i := 0 to ComponentCount -1 do
  begin
    if Components[i] is TSQLConnection then
    begin
      (Components[i] as TSQLConnection).Close;
    end
    else if Components[i] is TSQLDataSet then
    begin
      (Components[i] as TSQLDataSet).Close;
    end
    else if Components[i] is TClientDataSet then
    begin
      (Components[i] as TClientDataSet).Close;
    end;
  end;

  FrmServer.RemoveConexao;
end;

function TClassePrincipal.RetornaID(var DataIn: OleVariant): OleVariant;
begin
  CdsControlaID.Data := DataIn; //Recebendo parametros do cliente

  try
    repeat
      CdsControle.Close;
      CdsControle.Params[0].AsString := CdsControlaIDCAMPO.AsString;
      CdsControle.Open;
      if CdsControle.RecordCount = 1 then
      begin
        CdsControle.Edit;
        CdsControleVALOR.AsFloat := CdsControleVALOR.AsFloat + 1;
      end
      else if CdsControle.RecordCount = 0 then
      begin
        CdsControle.Insert;
        CdsControleCAMPO.AsString := CdsControlaIDCAMPO.AsString;
        CdsControleVALOR.AsFloat := 1;
      end;
      CdsControle.Post;
    until (CdsControle.ApplyUpdates(0) = 0);

    CdsControlaID.Edit;
    CdsControlaIDVALOR.AsFloat := CdsControleVALOR.AsFloat;
    CdsControlaID.Post;
  except
    CdsControlaID.Edit;
    CdsControlaIDVALOR.AsFloat := -1;
    CdsControlaID.Post;
  end;

  Result := CdsControlaID.Data;//Devolvendo os parametros pro cliente
  CdsControlaID.Close;
  CdsControle.Close;
end;

function TClassePrincipal.RetornaSQL(var DataIn: OleVariant): OleVariant;
var
  SQL  : TSQLDataSet;
  DSP  : TDataSetProvider;
  CDS  : TClientDataSet;
  sSQL : String;
begin
  sSQL := DataIn;

  SQL := TSQLDataSet.Create(Self);
  DSP := TDataSetProvider.Create(Self);
  CDS := TClientDataSet.Create(Self);

  SQL.SQLConnection := FrmServer.SQLConn;
  SQL.GetMetadata   := False;
  SQL.Name          := 'SQL';

  DSP.Name          := 'DSP';
  DSP.DataSet       := SQL;
  DSP.Options       := [poAllowCommandText, poReadOnly, poPropogateChanges, poAutoRefresh];

  CDS.Name          := 'CDS';
  CDS.ProviderName  := 'DSP';
  CDS.CommandText   := sSQL;

  try
    CDS.Open;
    Result := CDS.Data;
    CDS.Close;
  except
    raise EDatabaseError.Create('Erro de Retorno de Execuo de SQL: ' + #13 + sSQL);
  end;

  SQL.Free;
  DSP.Free;
  CDS.Free;
end;

procedure TClassePrincipal.DspControleBeforeApplyUpdates(Sender: TObject;
  var OwnerData: OleVariant);
begin
  if FrmServer = nil then
  begin
    FrmServer := TFrmServer.Create(self);
    ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
  end
  else if ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection = nil then
  begin
    try
      ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    except
      FrmServer := TFrmServer.Create(self);
      ((Sender as TDataSetProvider).DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    end;
  end;
end;

function TClassePrincipal.PegaData: OleVariant;
begin
  SqlDataHora.Close;
  SqlDataHora.Open;
  Result := SqlDataHoraDATA.AsVariant;
  SqlDataHora.Close;
end;

function TClassePrincipal.PegaDataHora: OleVariant;
begin
  SqlDataHora.Close;
  SqlDataHora.Open;
  Result := FormatDateTime('dd/mm/yyyy hh:mm:ss' ,SqlDataHoraDATAHORA.AsDateTime);
  SqlDataHora.Close;
end;

function TClassePrincipal.PegaHora: OleVariant;
begin
  SqlDataHora.Close;
  SqlDataHora.Open;
  Result := SqlDataHoraHORA.AsVariant;
  SqlDataHora.Close;
end;

function TClassePrincipal.RunSQL(var DataIn: OleVariant): OleVariant;
var
  sSQL : String;
  nAux : Real;
begin
  sSQL := DataIn;
  nAux := FrmServer.SQLConn.ExecuteDirect( sSQL );
  if nAux = 0 then
    Result := '0'
  else
    Result := FloatToStr(nAux);
end;

procedure TClassePrincipal.SqlControleBeforeOpen(DataSet: TDataSet);
begin
  if FrmServer = nil then
  begin
    FrmServer := TFrmServer.Create(self);
    (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
  end
  else if (DataSet as TSQLDataSet).SQLConnection = nil then
  begin
    try
      (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    except
      FrmServer := TFrmServer.Create(self);
      (DataSet as TSQLDataSet).SQLConnection := FrmServer.SQLConn;
    end;
  end;
end;

procedure TClassePrincipal.Timer1Timer(Sender: TObject);
begin
  if bActiveSecurity then
  begin
    if not bToken then
    begin
      FrmServer.BtDerrubarServerClick(FrmServer);
    end;
  end;
end;

function TClassePrincipal.Get_ClasseCadastro: IClasseCadastro;
begin
  Result := (ClasseCadastroFactory.CreateComObject(nil) as IClasseCadastro);
end;

function TClassePrincipal.Get_ClasseConsulta: IClasseConsulta;
begin
  Result := (ClasseConsultaFactory.CreateComObject(nil) as IClasseConsulta);
end;

function TClassePrincipal.IncluiPedidos(var Pedidos,
  Itens: OleVariant): OleVariant;
var
  TD       : TTransactionDesc;
  sSQL     : String;
  bFaz     : Boolean;
  Conector : TSQLConnection;
begin
  CdsPedidos.Data := Pedidos;
  CdsItens.Data   := Itens;
  bFaz := True;

  Conector               := TSQLConnection.Create(Self);
  Conector.DriverName    := 'Interbase';
  Conector.GetDriverFunc := 'getSQLDriverINTERBASE';
  Conector.LibraryName   := 'dbxint30.dll';
  Conector.LoginPrompt   := False;
  Conector.VendorLib     := 'GDS32.DLL';
  Conector.Params        := FrmServer.SQLConn.Params;
  Conector.Connected     := True;


  TD.TransactionID  := 1;
  TD.IsolationLevel := xilREPEATABLEREAD;
  Conector.StartTransaction(TD);

  sSQL := ' INSERT INTO PEDIDOS(ID_PEDIDO, ID_CLIENTE, DATAPED) ' +
          ' VALUES(' + CdsPedidosID_PEDIDO.AsString + ', ' +
          CdsPedidosID_CLIENTE.AsString + ', ' + '''' +
          FormatDateTime('mm/dd/yyyy', CdsPedidosDATAPED.AsDateTime) + '''' + ') ';

  try
    Conector.ExecuteDirect(sSQL);
    Result := CdsPedidosID_PEDIDO.AsFloat;
  except
    Result := -1;
    Conector.Rollback(TD);
    bFaz := False;
  end;

  if bFaz then
  begin
    CdsItens.First;
    while not CdsItens.Eof do
    begin
      sSQL := ' INSERT INTO ITENS(ID_PEDIDO, ID_PRODUTO, QUANTIDADE, PRECOVENDA) ' +
              ' VALUES(' + CdsPedidosID_PEDIDO.AsString + ', ' + CdsItensID_PRODUTO.AsString + ', ' +
                CdsItensQUANTIDADE.AsString + ', ' + CdsItensPRECOVENDA.AsString + ') ';
      try
        Conector.ExecuteDirect(sSQL);
        Result := CdsPedidosID_PEDIDO.AsFloat;
      except
        Result := -1;
        bFaz := False;
      end;
      if not(bFaz) then
        Break;
      CdsItens.Next;
    end;
  end;

  if bFaz then
    Conector.Commit(TD)
  else
  begin
    Conector.Rollback(TD);
  end;

  Conector.Close;
  Conector.Free;
  CdsPedidos.Close;
  CdsItens.Close;
end;

function TClassePrincipal.Get_MinhaClasseSecundaria: IClasseConsulta;
begin

end;

function TClassePrincipal.Get_ClasseRelatorios: IClasseRelatorios;
begin
  Result := (ClasseRelatoriosFactory.CreateComObject(nil) as IClasseRelatorios);
end;

procedure TClassePrincipal.SetToken(var DataIn: OleVariant);
begin
  CDSToken.Data := DataIn;
  if CDSTokenToken.AsBoolean then
  begin
    bToken := CDSTokenToken.AsBoolean;
  end;
  CDSToken.Close;
end;

initialization
  TComponentFactory.Create(ComServer, TClassePrincipal,
    Class_ClassePrincipal, ciMultiInstance, tmSingle);
end.
