unit URelatorios;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, CodeGearApplicationServer2007_TLB, StdVcl, MidasLib, DB, SqlExpr;

type
  TClasseRelatorios = class(TRemoteDataModule, IClasseRelatorios)
    procedure RemoteDataModuleDestroy(Sender: TObject);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

var
  ClasseRelatorios        : TClasseRelatorios;
  ClasseRelatoriosFactory : TComponentFactory;

implementation

uses UPrincipal, UServer;

{$R *.DFM}

procedure TClasseRelatorios.RemoteDataModuleDestroy(Sender: TObject);
var
  i : Integer;
begin
  for i := 0 to ComponentCount -1 do
  begin
    if Components[i] is TSQLConnection then
    begin
      (Components[i] as TSQLConnection).Close;
    end
    else if Components[i] is TSQLDataSet then
    begin
      (Components[i] as TSQLDataSet).Close;
    end
    else if Components[i] is TClientDataSet then
    begin
      (Components[i] as TClientDataSet).Close;
    end;
  end;
end;

class procedure TClasseRelatorios.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  ClasseRelatoriosFactory := TComponentFactory.Create(ComServer, TClasseRelatorios,
    Class_ClasseRelatorios, ciMultiInstance, tmSingle);
end.
