Unit UDMServer;

interface

uses SysUtils, Classes, InvokeRegistry, Midas, SOAPMidas, SOAPDm, DB, DBClient,
  MConnect, SConnect, SWSystem, Provider;

type
  IDMServer = interface(IAppServerSOAP)
    ['{15B51003-64EC-4BDA-AB96-4D7B70316623}']
  end;

  TDMServer = class(TSoapDataModule, IDMServer, IAppServerSOAP, IAppServer)
    Principal: TSocketConnection;
    Consulta: TSharedConnection;
    Cadastro: TSharedConnection;
    CdsConexao: TClientDataSet;
    CdsProdutos: TClientDataSet;
    CdsProdutosID_PRODUTO: TFloatField;
    CdsProdutosDESCRICAO: TStringField;
    CdsProdutosPRECOCOMPRA: TFloatField;
    CdsProdutosQUANTIDADE: TFloatField;
    DspProdutos: TDataSetProvider;
    procedure SoapDataModuleCreate(Sender: TObject);
  private
    procedure AbreConexaoServer; stdcall;  
  public
    function PegaProduto(ID : Real) : String; stdcall;
  end;

implementation

{$R *.DFM}

procedure TDMServerCreateInstance(out obj: TObject);
begin
 obj := TDMServer.Create(nil);
end;

{ TDMServer }

procedure TDMServer.AbreConexaoServer;
begin
  if not FileExists(gsAppPath + 'ConfigClientBSS.XML') then
  begin
    raise EDatabaseError.Create('Arquivo de configurao do cliente no encontrado');
    Exit;
  end;
  CdsConexao.Close;
  CdsConexao.LoadFromFile(gsAppPath + 'ConfigClientBSS.XML');
  try
    Principal.Connected := False;
    Principal.Port      := CdsConexao.Fields.FieldByName('Porta').AsInteger;
    Principal.Host      := Trim(CdsConexao.Fields.FieldByName('Host').AsString);
    Principal.Connected := True;
  except
    raise EDatabaseError.Create('Classe Principal no conectada');
  end;
end;

function TDMServer.PegaProduto(ID: Real): String;
begin
  CdsProdutos.Close;
  CdsProdutos.Params[0].AsString := '-1';
  CdsProdutos.Params[1].AsFloat  := ID;
  CdsProdutos.Open;

  if CdsProdutos.RecordCount = 1 then
  begin
    Result := CdsProdutosDESCRICAO.AsString;
  end
  else if CdsProdutos.RecordCount <= 0 then
  begin
    Result := 'Sem Produtos';
  end;
end;

procedure TDMServer.SoapDataModuleCreate(Sender: TObject);
begin
  AbreConexaoServer;
end;

initialization
   InvRegistry.RegisterInvokableClass(TDMServer, TDMServerCreateInstance);
   InvRegistry.RegisterInterface(TypeInfo(IDMServer));
end.
