unit UHardware;

interface

uses
 SysUtils, UImpressoraECF;

type
 THardware = class
 private
    FImpressoraECF: TImpressoraECF;
    function GetImpressoraECF: TImpressoraECF;
 public
  constructor Create;
  destructor Destroy; override;
  property  ImpressoraECF: TImpressoraECF read GetImpressoraECF;
 end;

var
  Hardware: THardware;

implementation

{ THardware }

constructor THardware.Create;
begin
  FImpressoraECF := TImpressoraECF.Create;
end;

destructor THardware.Destroy;
begin
  if Assigned(FImpressoraECF) then
   FreeAndNil(FImpressoraECF);
end;

function THardware.GetImpressoraECF: TImpressoraECF;
begin
  Result := FImpressoraECF;
end;

initialization
  Hardware := THardware.Create;

finalization
  if Assigned(Hardware) then
    FreeAndNil(Hardware);
end.
