unit UItem;

interface

uses
  SysUtils, contnrs, Classes;

type
  TItem = Class
  private
    FValor: Currency;
    FQuantidade: Integer;
    FDescricao: String;
    FCodigo: String;
    function GetValorAsString: String;
    procedure SetCodigo(const Value: String);
    procedure SetDescricao(const Value: String);
    procedure SetValor(const Value: Currency);
    procedure SetValorAsString(const Value: String);
  public
    property Codigo: String read FCodigo write SetCodigo;
    property Descricao: String read FDescricao write SetDescricao;
    property Valor: Currency read FValor write SetValor;
    property ValorAsString: String read GetValorAsString write SetValorAsString;
  end;

  TItems = class(TObjectList)
  private
    function  GetItem(Index: Integer): TItem;
    procedure SetItem(Index: Integer; const Value: TItem);
  public
    Constructor Create;

    // adiciona um item na lista e retorna sua referncia
    function AddItem: TItem;

    function FindItemByCodigo(const Codigo: String): TItem;

    // Carrega Itens de um arquivo de texto
    procedure LoadItemsFromDisk(const FileName: String);

    property Items[Index: Integer]: TItem read GetItem write SetItem; default;
  end;

implementation

{ TItem }

function TItem.GetValorAsString: String;
begin
  Result := FormatFloat('##,#0.00',Valor);
end;

procedure TItem.SetCodigo(const Value: String);
begin
  if Value = '' then
    Raise Exception.Create('Cdigo no pode estar em Branco !');
  FCodigo := Value;
end;

procedure TItem.SetDescricao(const Value: String);
begin
  FDescricao := Value;
end;

procedure TItem.SetValor(const Value: Currency);
begin
  if Value < 0 then
    Raise Exception.Create('Valor do Item no pode ser menor que zero !');
  FValor := Value;
end;

procedure TItem.SetValorAsString(const Value: String);
begin
  Valor := StrToFloatDef(Value,0);
end;

{ TItems }

function TItems.AddItem: TItem;
begin
  Result := TItem.Create;
  Add(Result);
end;

constructor TItems.Create;
begin
   inherited Create(true);
end;

function TItems.FindItemByCodigo(const Codigo: String): TItem;
var
  i: Integer;
begin
  Result := nil;
  for i := 0 to Count - 1 do begin
    if Items[i].Codigo = codigo then begin
      Result := Items[i];
      Break;
    end;
  end;
end;

function TItems.GetItem(Index: Integer): TItem;
begin
  Result := TItem(inherited GetItem(Index));
end;

procedure TItems.LoadItemsFromDisk;
var
  i: integer;
  ItensFile: TStringList;
  CurrentItem: TStringList;
begin
  ItensFile := TStringList.Create;
  CurrentItem := TStringList.Create;
  CurrentItem.Delimiter := ';';
  try
    ItensFile.LoadFromFile(FileName);
    for i := 0 to ItensFile.Count - 1 do begin
     CurrentItem.DelimitedText := ItensFile[i];
     if CurrentItem.Count <> 3 then
       raise exception.create('Erro lendo item numero ' + IntToStr(i));
     with AddItem do begin
       Codigo := CurrentItem[0];
       Descricao := CurrentItem[1];
       ValorAsString := CurrentItem[2];
     end;
    end;
  finally
    ItensFile.Free;
    CurrentItem.Free;
  end;
end;

procedure TItems.SetItem(Index: Integer; const Value: TItem);
begin
   inherited SetItem(Index,Value);
end;

end.

