unit Default;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Data.Web, System.Globalization;

type
  TDefault = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure DBWebDtsBoletos_OnApplyChangesRequest(sender: System.Object; e: Borland.Data.Web.WebControlEventArgs);
    procedure btnCancelar_Click(sender: System.Object; e: System.EventArgs);
    procedure btnImprimir_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dtsBoletos: System.Data.DataSet;
    dtbBoletos: System.Data.DataTable;
    IdBoleto: System.Data.DataColumn;
    DtVencimento: System.Data.DataColumn;
    DtDocumento: System.Data.DataColumn;
    DtProcessamento: System.Data.DataColumn;
    NuDocumento: System.Data.DataColumn;
    NossoNumero: System.Data.DataColumn;
    Carteira: System.Data.DataColumn;
    VlDocumento: System.Data.DataColumn;
    Instrucoes: System.Data.DataColumn;
    Sacado: System.Data.DataColumn;
    Endereco: System.Data.DataColumn;
    Bairro: System.Data.DataColumn;
    Cidade: System.Data.DataColumn;
    Estado: System.Data.DataColumn;
    CpfCgc: System.Data.DataColumn;
    btnNovo: System.Web.UI.WebControls.Button;
    btnCancelar: System.Web.UI.WebControls.Button;
    btnExcluir: System.Web.UI.WebControls.Button;
    DBWebDtsBoletos: Borland.Data.Web.DBWebDataSource;
    txtIdBoleto: Borland.Data.Web.DBWebLabeledTextBox;
    DBWebNavExBoletos: Borland.Data.Web.DBWebNavigationExtender;
    btnAplicar: System.Web.UI.WebControls.Button;
    txtDtVencimento: Borland.Data.Web.DBWebLabeledTextBox;
    txtDtDocumento: Borland.Data.Web.DBWebLabeledTextBox;
    txtDtProcessamento: Borland.Data.Web.DBWebLabeledTextBox;
    txtNuDocumento: Borland.Data.Web.DBWebLabeledTextBox;
    txtNossoNumero: Borland.Data.Web.DBWebLabeledTextBox;
    txtCarteira: Borland.Data.Web.DBWebLabeledTextBox;
    txtVlDocumento: Borland.Data.Web.DBWebLabeledTextBox;
    MemoInstrucoes: Borland.Data.Web.DBWebMemo;
    txtSacado: Borland.Data.Web.DBWebLabeledTextBox;
    txtEndereco: Borland.Data.Web.DBWebLabeledTextBox;
    txtCidade: Borland.Data.Web.DBWebLabeledTextBox;
    txtEstado: Borland.Data.Web.DBWebLabeledTextBox;
    txtCpfCgc: Borland.Data.Web.DBWebLabeledTextBox;
    txtBairro: Borland.Data.Web.DBWebLabeledTextBox;
    txtCep: Borland.Data.Web.DBWebLabeledTextBox;
    lblInstrucoes: System.Web.UI.WebControls.Label;
    DBWebGridBoletos: Borland.Data.Web.DBWebGrid;
    btnImprimir: System.Web.UI.WebControls.Button;
    Cep: System.Data.DataColumn;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
    procedure LoadData;
    function DataPath: string;
  protected
  public
    { Public Declarations }
  end;

{$AUTOBOX ON}

implementation

uses
  System.IO, SysUtils;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TDefault.InitializeComponent;
type
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
begin
  Self.dtbBoletos := System.Data.DataTable.Create;
  Self.IdBoleto := System.Data.DataColumn.Create;
  Self.DtVencimento := System.Data.DataColumn.Create;
  Self.DtDocumento := System.Data.DataColumn.Create;
  Self.DtProcessamento := System.Data.DataColumn.Create;
  Self.NuDocumento := System.Data.DataColumn.Create;
  Self.NossoNumero := System.Data.DataColumn.Create;
  Self.Carteira := System.Data.DataColumn.Create;
  Self.VlDocumento := System.Data.DataColumn.Create;
  Self.Instrucoes := System.Data.DataColumn.Create;
  Self.Sacado := System.Data.DataColumn.Create;
  Self.Endereco := System.Data.DataColumn.Create;
  Self.Bairro := System.Data.DataColumn.Create;
  Self.Cidade := System.Data.DataColumn.Create;
  Self.Estado := System.Data.DataColumn.Create;
  Self.CpfCgc := System.Data.DataColumn.Create;
  Self.Cep := System.Data.DataColumn.Create;
  Self.dtsBoletos := System.Data.DataSet.Create;
  Self.DBWebDtsBoletos := Borland.Data.Web.DBWebDataSource.Create;
  Self.DBWebNavExBoletos := Borland.Data.Web.DBWebNavigationExtender.Create;
  (System.ComponentModel.ISupportInitialize(Self.dtbBoletos)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dtsBoletos)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DBWebDtsBoletos)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DBWebNavExBoletos)).BeginInit;
  Include(Self.btnCancelar.Click, Self.btnCancelar_Click);
  Include(Self.btnImprimir.Click, Self.btnImprimir_Click);
  //
  // dtbBoletos
  // 
  Self.dtbBoletos.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.IdBoleto, 
          Self.DtVencimento, Self.DtDocumento, Self.DtProcessamento, Self.NuDocumento, 
          Self.NossoNumero, Self.Carteira, Self.VlDocumento, Self.Instrucoes, 
          Self.Sacado, Self.Endereco, Self.Bairro, Self.Cidade, Self.Estado, 
          Self.CpfCgc, Self.Cep));
  Self.dtbBoletos.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('IdBoleto'), True)));
  Self.dtbBoletos.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.IdBoleto);
  Self.dtbBoletos.TableName := 'tblBoletos';
  // 
  // IdBoleto
  // 
  Self.IdBoleto.AllowDBNull := False;
  Self.IdBoleto.AutoIncrement := True;
  Self.IdBoleto.AutoIncrementSeed := (Int64(1));
  Self.IdBoleto.ColumnName := 'IdBoleto';
  Self.IdBoleto.DataType := TypeOf(Integer);
  // 
  // DtVencimento
  // 
  Self.DtVencimento.AllowDBNull := False;
  Self.DtVencimento.ColumnName := 'DtVencimento';
  Self.DtVencimento.DataType := TypeOf(System.DateTime);
  // 
  // DtDocumento
  // 
  Self.DtDocumento.AllowDBNull := False;
  Self.DtDocumento.ColumnName := 'DtDocumento';
  Self.DtDocumento.DataType := TypeOf(System.DateTime);
  // 
  // DtProcessamento
  // 
  Self.DtProcessamento.AllowDBNull := False;
  Self.DtProcessamento.ColumnName := 'DtProcessamento';
  Self.DtProcessamento.DataType := TypeOf(System.DateTime);
  // 
  // NuDocumento
  // 
  Self.NuDocumento.AllowDBNull := False;
  Self.NuDocumento.ColumnName := 'NuDocumento';
  // 
  // NossoNumero
  // 
  Self.NossoNumero.AllowDBNull := False;
  Self.NossoNumero.ColumnName := 'NossoNumero';
  // 
  // Carteira
  // 
  Self.Carteira.AllowDBNull := False;
  Self.Carteira.ColumnName := 'Carteira';
  Self.Carteira.DataType := TypeOf(SmallInt);
  Self.Carteira.DefaultValue := (SmallInt(17));
  // 
  // VlDocumento
  // 
  Self.VlDocumento.AllowDBNull := False;
  Self.VlDocumento.ColumnName := 'VlDocumento';
  Self.VlDocumento.DataType := TypeOf(System.Double);
  Self.VlDocumento.DefaultValue := 1;
  // 
  // Instrucoes
  // 
  Self.Instrucoes.ColumnName := 'Instrucoes';
  Self.Instrucoes.DefaultValue := 'PROTESTAR APS CINCO DIAS';
  // 
  // Sacado
  // 
  Self.Sacado.AllowDBNull := False;
  Self.Sacado.ColumnName := 'Sacado';
  // 
  // Endereco
  // 
  Self.Endereco.AllowDBNull := False;
  Self.Endereco.ColumnName := 'Endereco';
  // 
  // Bairro
  // 
  Self.Bairro.AllowDBNull := False;
  Self.Bairro.ColumnName := 'Bairro';
  // 
  // Cidade
  // 
  Self.Cidade.AllowDBNull := False;
  Self.Cidade.ColumnName := 'Cidade';
  // 
  // Estado
  // 
  Self.Estado.AllowDBNull := False;
  Self.Estado.ColumnName := 'Estado';
  // 
  // CpfCgc
  // 
  Self.CpfCgc.AllowDBNull := False;
  Self.CpfCgc.ColumnName := 'CpfCgc';
  // 
  // Cep
  // 
  Self.Cep.Caption := 'Cep';
  Self.Cep.ColumnName := 'Cep';
  // 
  // dtsBoletos
  // 
  Self.dtsBoletos.DataSetName := 'dtsBoletos';
  Self.dtsBoletos.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.dtsBoletos.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.dtbBoletos));
  // 
  // DBWebDtsBoletos
  // 
  Self.DBWebDtsBoletos.DataSource := Self.dtsBoletos;
  Self.DBWebDtsBoletos.ErrorDlgBackColor := System.Drawing.Color.Azure;
  Self.DBWebDtsBoletos.ErrorDlgBorderColor := System.Drawing.Color.Red;
  Self.DBWebDtsBoletos.ErrorDlgForeColor := System.Drawing.Color.Black;
  Self.DBWebDtsBoletos.XMLFileName := '';
  Self.DBWebDtsBoletos.XSDSchemaFile := '';
  Include(Self.DBWebDtsBoletos.OnApplyChangesRequest, Self.DBWebDtsBoletos_OnApplyChangesRequest);
  // 
  // DBWebNavExBoletos
  // 
  Self.DBWebNavExBoletos.NavObjects.Add(Borland.Data.Web.DBWebNavObject.Create(Self.btnCancelar, 
        Borland.Data.Web.DataSetAction.UndoAll, Self.DBWebDtsBoletos, 'tblBo' +
      'letos'));
  Self.DBWebNavExBoletos.NavObjects.Add(Borland.Data.Web.DBWebNavObject.Create(Self.btnNovo, 
        Borland.Data.Web.DataSetAction.Insert, Self.DBWebDtsBoletos, 'tblBol' +
      'etos'));
  Self.DBWebNavExBoletos.NavObjects.Add(Borland.Data.Web.DBWebNavObject.Create(Self.btnExcluir, 
        Borland.Data.Web.DataSetAction.Delete, Self.DBWebDtsBoletos, 'tblBol' +
      'etos'));
  Self.DBWebNavExBoletos.NavObjects.Add(Borland.Data.Web.DBWebNavObject.Create(Self.btnAplicar, 
        Borland.Data.Web.DataSetAction.Apply, Self.DBWebDtsBoletos, 'tblBole' +
      'tos'));
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.dtbBoletos)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dtsBoletos)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DBWebDtsBoletos)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DBWebNavExBoletos)).EndInit;
end;

procedure TDefault.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$ENDREGION}

  procedure TDefault.Page_Load(sender: System.Object; e: System.EventArgs);
  begin
    // TODO: Put user code to initialize the page here
    LoadData;

    DtVencimento.DefaultValue    := FormatDateTime('dd/mm/yyyy', Now);
    DtDocumento.DefaultValue     := FormatDateTime('dd/mm/yyyy', Now);
    DtProcessamento.DefaultValue := FormatDateTime('dd/mm/yyyy', Now);
    Carteira.DefaultValue        := 17;
    VlDocumento.DefaultValue     := '1,00';
  end;

procedure TDefault.LoadData;
begin
  if ( FileExists( DataPath ) ) then
  begin
    dtsBoletos.Clear;
    dtsBoletos.ReadXml(DataPath);
  end;
end;

function TDefault.DataPath: string;
begin
  Result := MapPath(Request.ApplicationPath + '\Data\Boletos.xml');
end;

procedure TDefault.DBWebDtsBoletos_OnApplyChangesRequest(sender: System.Object;
  e: Borland.Data.Web.WebControlEventArgs);
begin
  e.DataSet.WriteXml(DataPath, XmlWriteMode.WriteSchema);
end;

procedure TDefault.btnImprimir_Click(sender: System.Object; e: System.EventArgs);
begin
  Response.Redirect('WFPrintBoletos.aspx');
end;

procedure TDefault.btnCancelar_Click(sender: System.Object; e: System.EventArgs);
begin
  LoadData;
end;

end.

