
unit WFPrintBoletos;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWFPrintBoletos = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnConfirma_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCancela_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    txtCedente: System.Web.UI.WebControls.TextBox;
    txtAgencia: System.Web.UI.WebControls.TextBox;
    txtConta: System.Web.UI.WebControls.TextBox;
    Label1: System.Web.UI.WebControls.Label;
    Label2: System.Web.UI.WebControls.Label;
    lstBanco: System.Web.UI.WebControls.DropDownList;
    Label3: System.Web.UI.WebControls.Label;
    Label4: System.Web.UI.WebControls.Label;
    lstAceite: System.Web.UI.WebControls.DropDownList;
    Label5: System.Web.UI.WebControls.Label;
    Label6: System.Web.UI.WebControls.Label;
    txtConvenio: System.Web.UI.WebControls.TextBox;
    Label7: System.Web.UI.WebControls.Label;
    txtEspecieDoc: System.Web.UI.WebControls.TextBox;
    Label8: System.Web.UI.WebControls.Label;
    txtEspecieMoeda: System.Web.UI.WebControls.TextBox;
    Label9: System.Web.UI.WebControls.Label;
    txtLocal: System.Web.UI.WebControls.TextBox;
    btnConfirma: System.Web.UI.WebControls.Button;
    btnCancela: System.Web.UI.WebControls.Button;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses
  SysUtils, uBoletos;
  
{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWFPrintBoletos.InitializeComponent;
begin
  Include(Self.btnConfirma.Click, Self.btnConfirma_Click);
  Include(Self.btnCancela.Click, Self.btnCancela_Click);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWFPrintBoletos.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here
  if ( not Page.IsPostBack ) then
  begin
    txtCedente.Text := 'TDS TECNOLOGIA';
    lstBanco.SelectedValue := '001';
    txtAgencia.Text := '00047';
    txtConta.Text := '76549-0';
    lstAceite.SelectedValue := 'N';
    txtConvenio.Text := '123456';
    txtEspecieDoc.Text := 'DM';
    txtEspecieMoeda.Text := 'R$';
    txtLocal.Text := 'PAGVEL EM QUALQUER AGNCIA BANCARIA AT O VENCIMENTO'
  end;
end;

procedure TWFPrintBoletos.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWFPrintBoletos.btnCancela_Click(sender: System.Object; e: System.EventArgs);
begin
  Response.Redirect('Default.aspx');
end;

procedure TWFPrintBoletos.btnConfirma_Click(sender: System.Object; e: System.EventArgs);
var
  Boletos : TBoletos;
begin
  try
    Boletos := TBoletos.Create(Self);
    Boletos.Aceite := lstAceite.SelectedValue;
    Boletos.Agencia := txtAgencia.Text;
    Boletos.Banco := lstBanco.SelectedValue;
    Boletos.Cedente := txtCedente.Text;
    Boletos.Conta := txtConta.Text;
    Boletos.Convenio := txtConvenio.Text;
    Boletos.EspecieDoc := txtEspecieDoc.Text;
    Boletos.EspecieMoeda := txtEspecieMoeda.Text;
    Boletos.LocalPagamento := txtLocal.Text;
    Boletos.Page := Self;
    Boletos.PrintBoletos;
  finally
    FreeAndNil(Boletos);
  end;
end;

end.

