unit uBanco;

interface

type
  TBanco = class
  private
    FBanco: string;
    FConta: string;
    FAgencia: string;
    FNossoNumero: string;
    FVencimento: TDateTime;
    FValor: Double;
  public
    function AgenciaCodigo: string; virtual; abstract;
    function CampoLivre: string; virtual; abstract;
    function CodigoBarras: string; virtual; abstract;
    function Imagem: TObject; virtual; abstract;
    function LinhaDigitavel: string; virtual; abstract;
    function Sequencia: string; virtual; abstract;
    function get_NossoNumero: string; virtual; abstract;

    function DvCodigoBarras(CodigoBarras: string) : Integer;
    function FatorVenc: string;
    function Modulo10(Numero: string): string;
    function Modulo11(Numero: string): string;

    property Agencia: string read FAgencia write FAgencia;
    property Banco: string read FBanco;
    property Conta: string read FConta write FConta;
    property NossoNumero: string read get_NossoNumero write FNossoNumero;
    property Vencimento: TDateTime read FVencimento write FVencimento;
    property Valor: Double read FValor write FValor;
  end;

  TBanco001 = class(TBanco)
  private
    FConvenio: string;
  public
    constructor Create(CodConvenio: string);

    function AgenciaCodigo: string; override;
    function CampoLivre: string; override;
    function CodigoBarras: string; override;
    function Imagem: TObject; override;
    function LinhaDigitavel: string; override;
    function Sequencia: string; override;
    function get_NossoNumero: string; override;

    function Tipo : string;
    function get_Convenio: string;

    property Convenio: string read get_Convenio;
  end;

implementation

uses
  SysUtils, StrUtils, DateUtils;

{ TBanco }

function TBanco.DvCodigoBarras(CodigoBarras: string): Integer;
var
  iCont, iTotal : Integer;
  iFator : Integer;
  c : string;
begin
  iFator := 2;
  iTotal := 0;
  
  for iCont := 1 to 43 do
  begin
    c := CodigoBarras[iCont];

    if ( iFator > 9 ) then
      iFator := 2;

    iTotal := iTotal + ( StrToInt(c) * iFator );
    Inc(iFator, 1);
  end;

  Result := 11 - ( iTotal mod 11 );

  if ( Result = 10 ) or ( Result = 11 ) then
    Result := 1;
end;

function TBanco.FatorVenc: string;
var
  dbDate : TDateTime;
begin
  dbDate := Convert.ToDateTime('7/10/1997');
  Result := DaysBetween(dbDate, Vencimento).ToString;
end;

function TBanco.Modulo10(Numero: string): string;
var
  iCont : Integer;
  iSoma : Integer;
  iAcum : Integer;
  iFator : Integer;
  iResto : Integer;
  iProxDez : Integer;
begin
  iFator := 2;
  iAcum  := 0;

  for iCont := Length(Numero) downto 1 do
  begin
    iSoma := StrToInt(Numero[iCont]) * iFator;

    while ( iSoma > 9 ) do
      iSoma := StrToInt(copy(IntToStr(iSoma), 1, 1)) +
                   StrToInt(copy(IntToStr(iSoma), 2, 1));

    iAcum := iAcum + iSoma;

    if ( iFator = 2 ) then
      iFator := 1
    else iFator := 2;
  end;

  if ( iAcum < 10 ) then
    iProxDez := 10
  else iProxDez := 10 * ( ( iAcum div 10 ) + 1);

  iResto := iProxDez - iAcum;

  case iResto of
    10 : Result := '0';
  else
   Result := IntToStr(iResto);
  end;
end;

function TBanco.Modulo11(Numero: string): string;
var
  iCont : Integer;
  iAcum : Integer;
  iTotal : Integer;
  iFator : Integer;
  iResto : Integer;
begin
  iFator := 9;
  iTotal := 0;
  for iCont := Length(Numero) downto 1 do
  begin
    iAcum := StrToInt(Numero[iCont]) * iFator;

    iTotal := iTotal + iAcum;

    if ( iFator > 2 ) then
      Dec(iFator, 1)
    else iFator := 9;
  end;

  iResto := iTotal mod 11;

  case iResto of
    0 : Result := '0';
    10: Result := 'X';
  else Result := IntToStr(iResto);
  end;
end;

{ TBanco001 }

function TBanco001.AgenciaCodigo: string;
begin
  Result := Agencia + '-' + Modulo11(Agencia) + '/000' + Conta;
end;

function TBanco001.CampoLivre: string;
begin
  Result := Convenio + FormatFloat('00000000000000000',
                                   StrToIntDef(FNossoNumero, 0)) + Tipo;
end;

function TBanco001.CodigoBarras: string;
var
  sCodigo : string;
begin
  Result  := Sequencia;
  sCodigo := DvCodigoBarras(Result).ToString;

  Insert(sCodigo, Result, 5);
end;

constructor TBanco001.Create(CodConvenio: string);
begin
  inherited Create;
  FBanco := '001';
  FConvenio := CodConvenio;
end;

function TBanco001.get_Convenio: string;
begin
  Result := FormatFloat('000000', StrToIntDef(FConvenio, 0));
end;

function TBanco001.get_NossoNumero: string;
begin
  Result := FormatFloat('00000000000000000', StrToIntDef(FNossoNumero, 0)) +
            '-' + Modulo11(FNossoNumero);
end;

function TBanco001.Imagem: TObject;
begin
  Result := '001.jpg';
end;

function TBanco001.LinhaDigitavel: string;
var
  Seq01, Seq02, Seq03, Seq04, Seq05: string;
begin
  Seq01 := '0019' + Copy(CampoLivre, 1, 5);
  Seq01 := Seq01 + Modulo10(Seq01);
  Insert('.', Seq01, 6);

  Seq02 := Copy(CampoLivre, 6, 10);
  Seq02 := Seq02 + Modulo10(Seq02);
  Insert('.', Seq02, 6);

  Seq03 := Copy(CampoLivre, 16, 10);
  Seq03 := Seq03 + Modulo10(Seq03);
  Insert('.', Seq03, 6);

  Seq04 := DvCodigoBarras(Sequencia).ToString;

  Seq05 := FatorVenc + FormatFloat('0000000000', Valor * 100);

  Result := Seq01 + ' ' + Seq02 + ' ' + Seq03 + ' ' + Seq04 + ' ' + Seq05;
end;

function TBanco001.Sequencia: string;
var
  sFator : string;
  sValor : string;
begin
  sFator  := FatorVenc;
  sValor  := FormatFloat('0000000000', Valor * 100);
  Result  := Banco + '9' + sFator + sValor + CampoLivre;
end;

function TBanco001.Tipo: string;
begin
  Result := '21';
end;

end.
