unit uBoletos;

interface

uses
  System.Web.UI, System.Data, C1.Win.C1Report, C1.Web.C1WebReport, uBanco;

type
  TBoletos = class
  private
    FConvenio: string;
    FCedente: string;
    FLocalPagamento: string;
    FEspecieDoc: string;
    FAceite: string;
    FEspecieMoeda: string;
    FPage: System.Web.UI.Page;
    FC1WebRpt: C1WebReport;
    FBanco: string;
    FConta: string;
    FAgencia: string;
    { Private Declarations }
  protected
    procedure C1WebRpt_PrintSection(sender : TObject;
                                    e : C1.Win.C1Report.ReportEventArgs);
    procedure PopulateFields(oBanco : TBanco;
                             Section : C1.Win.C1Report.Section);
  public
    constructor Create(aPage : System.Web.UI.Page);

    procedure set_Aceite(const Value: string);
    procedure set_Cedente(const Value: string);
    procedure set_Convenio(const Value: string);
    procedure set_LocalPagamento(const Value: string);
    procedure set_EspecieDoc(const Value: string);
    procedure set_EspecieMoeda(const Value: string);
    procedure set_Page(const Value: System.Web.UI.Page);

    procedure PrintBoletos;

    procedure set_Agencia(const Value: string);
    procedure set_Banco(const Value: string);
    procedure set_Conta(const Value: string);

    property Aceite: string read FAceite write set_Aceite;
    property Banco: string read FBanco write set_Banco;
    property Agencia: string read FAgencia write set_Agencia;
    property Conta: string read FConta write set_Conta;
    property Cedente: string read FCedente write set_Cedente;
    property Convenio: string read FConvenio write set_Convenio;
    property EspecieDoc: string read FEspecieDoc write set_EspecieDoc;
    property EspecieMoeda: string read FEspecieMoeda write set_EspecieMoeda;
    property LocalPagamento: string read FLocalPagamento write set_LocalPagamento;
    property Page: System.Web.UI.Page read FPage write set_Page;
    property C1WebRpt : C1WebReport read FC1WebRpt;
  end;

implementation

uses
  SysUtils;

{TBoletos}

constructor TBoletos.Create(aPage : System.Web.UI.Page);
begin
  inherited Create;

  Page := aPage;
end;

procedure TBoletos.PopulateFields(oBanco : TBanco;Section : C1.Win.C1Report.Section);
var
  dtVenc : DateTime;
  VlDoc : Double;
  NossoNum : string;
begin
  Section.Fields['FNossoNumero'].Calculated := True;
  Section.Fields['FNossoNumero'].Text := 'NossoNumero';

  dtVenc   := Convert.ToDateTime(Section.Fields['FDtVencimento'].Value);
  VlDoc    := Convert.ToDouble(Section.Fields['FVlDocumento'].Value);
  NossoNum := Convert.ToString(Section.Fields['FNossoNumero'].Value);

  Section.Fields['FNossoNumero'].Calculated := False;

  oBanco.Agencia := Agencia;
  oBanco.Conta   := Conta;

  oBanco.NossoNumero := NossoNum;
  oBanco.Vencimento  := dtVenc;
  oBanco.Valor       := VlDoc;

  Section.Fields['FImage'].Picture       := oBanco.Imagem;
  Section.Fields['FBanco'].Text          := oBanco.Banco + '-9';
  Section.Fields['FLinhaDigitavel'].Text := oBanco.LinhaDigitavel;
  Section.Fields['FLocal'].Text          := Self.LocalPagamento;
  Section.Fields['FCedente'].Text        := Self.Cedente;
  Section.Fields['FAgenciaCodigo'].Text  := oBanco.AgenciaCodigo;
  Section.Fields['FNossoNumero'].Text    := oBanco.NossoNumero;
  Section.Fields['FCodigoBarras'].Text   := oBanco.CodigoBarras;

  Section.Fields['FImage1'].Picture       := Section.Fields['FImage'].Picture;
  Section.Fields['FBanco1'].Text          := Section.Fields['FBanco'].Text;
  Section.Fields['FLinhaDigitavel1'].Text := Section.Fields['FLinhaDigitavel'].Text;
  Section.Fields['FLocal1'].Text          := Section.Fields['FLocal'].Text;
  Section.Fields['FCedente1'].Text        := Section.Fields['FCedente'].Text;
  Section.Fields['FAgenciaCodigo1'].Text  := Section.Fields['FAgenciaCodigo'].Text;
  Section.Fields['FNossoNumero1'].Text    := Section.Fields['FNossoNumero'].Text;
  Section.Fields['FCodigoBarras1'].Text   := Section.Fields['FCodigoBarras'].Text;
end;

procedure TBoletos.PrintBoletos;
var
  sPath : string;
  sFileName : string;
  sReport : string;
begin
  with Page do
  begin
    sFileName := MapPath(Request.ApplicationPath + '\report\Reports.xml');

    FC1WebRpt := C1.Web.C1WebReport.C1WebReport.Create;
    Include(C1WebRpt.PrintSection, C1WebRpt_PrintSection);

    C1WebRpt.ReportSource.FileName   := sFileName;
    C1WebRpt.ReportSource.ReportName := 'rptBoletos';

    sReport := C1WebRpt.ReportSource.ReportName.Trim + Session.SessionID + '.pdf';
    sPath := MapPath(Request.ApplicationPath) + '\temp\' + sReport;
    C1WebRpt.Report.RenderToFile(sPath, FileFormatEnum.PDFPrintUtil);
    Response.Write('<script>window.open("' + 'temp/' + sReport + '");</script>');
  end;
end;

procedure TBoletos.set_Aceite(const Value: string);
begin
  FAceite := Value;
end;

procedure TBoletos.set_Agencia(const Value: string);
begin
  FAgencia := Value;
end;

procedure TBoletos.set_Banco(const Value: string);
begin
  FBanco := Value;
end;

procedure TBoletos.set_Cedente(const Value: string);
begin
  FCedente := Value;
end;

procedure TBoletos.set_Conta(const Value: string);
begin
  FConta := Value;
end;

procedure TBoletos.set_Convenio(const Value: string);
begin
  FConvenio := Value;
end;

procedure TBoletos.set_EspecieDoc(const Value: string);
begin
  FEspecieDoc := Value;
end;

procedure TBoletos.set_EspecieMoeda(const Value: string);
begin
  FEspecieMoeda := Value;
end;

procedure TBoletos.set_LocalPagamento(const Value: string);
begin
  FLocalPagamento := Value;
end;

procedure TBoletos.set_Page(const Value: System.Web.UI.Page);
begin
  FPage := Value;
end;

procedure TBoletos.C1WebRpt_PrintSection(sender: TObject;
  e: C1.Win.C1Report.ReportEventArgs);
var
  oBanco : TBanco;
begin
  if ( e.Section = SectionTypeEnum.Detail ) then
  begin
    case Int32.Parse( Banco ) of
      1 : oBanco := TBanco001.Create(Convenio);
    end;

    PopulateFields(oBanco, C1WebRpt.Report.Sections[e.Section]);
  end;
end;

end.
