unit uFrmActiveBackup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, Menus, ComCtrls, ToolWin, Buttons, StdCtrls, ExtCtrls,
  CheckLst, FileCtrl;

type
  TfrmActiveBackup = class(TForm)
    edtNome: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    edtDestino: TEdit;
    lstOrigens: TListView;
    Label3: TLabel;
    btnDiretorio: TButton;
    btnAdicionaArquivos: TBitBtn;
    btnAdicionaDiretorios: TBitBtn;
    btnRemove: TBitBtn;
    ToolBar1: TToolBar;
    tlbIncluir: TToolButton;
    tlbAbrir: TToolButton;
    tlbSalvar: TToolButton;
    ToolButton4: TToolButton;
    tlbSair: TToolButton;
    MainMenu1: TMainMenu;
    Arquivo1: TMenuItem;
    Sair1: TMenuItem;
    NovoBackup1: TMenuItem;
    AbrirBackup1: TMenuItem;
    SalvarBackup1: TMenuItem;
    imgBar: TImageList;
    ckbSemana: TCheckListBox;
    Label4: TLabel;
    Label5: TLabel;
    ckbHorarios: TCheckListBox;
    Bevel1: TBevel;
    dlgArquivo: TOpenDialog;
    procedure Alterado(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SalvarBackup1Click(Sender: TObject);
    procedure btnAdicionaArquivosClick(Sender: TObject);
    procedure btnAdicionaDiretoriosClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure AbrirBackup1Click(Sender: TObject);
    procedure NovoBackup1Click(Sender: TObject);
    procedure edtNomeKeyPress(Sender: TObject; var Key: Char);
    procedure Sair1Click(Sender: TObject);
    procedure btnDiretorioClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    sPath:String;
    sArquivoAberto:String;
    bAlterado:Boolean;
    procedure AdicionaItem(Caption:String; ListView:TListView);
    procedure CarregaArquivo(Arquivo: String);
    function SalvaAlteracao:Boolean;
    function SalvarArquivo: Boolean;
  public
    { Public declarations }
  end;

var
  frmActiveBackup: TfrmActiveBackup;

implementation

uses uFuncoes, uFrmDlgArquivos;

{$R *.dfm}

procedure TfrmActiveBackup.CarregaArquivo(Arquivo:String);
  procedure CarregaOrigens(Origens:String);
  var
    Linha:String;
  begin
    Linha := Origens;
    while Length(linha) > 0  do
      AdicionaItem(QuebraString(Linha), lstOrigens);
  end;
  Var
    i: Integer;
begin
  {Carregando o nome do Backup}
  edtNome.Text := LerArquivoString(Arquivo,'DADOS','Nome');

  {Carregando o destino no backup}
  edtDestino.Text := LerArquivoString(Arquivo,'DADOS','Destino');

  {Carregando Lista de Origens}
  lstOrigens.Items.Clear;
  CarregaOrigens(LerArquivoString(Arquivo,'DADOS','Origens'));

  {Marcando os checbox para identificar os dias da semana para a execuo do backup}
  for i := 0 to ckbSemana.Count - 1 do
    ckbSemana.Checked[i] := LerArquivoBool(Arquivo,'SEMANA',ckbSemana.Items.Strings[i]);

  for i := 0 to ckbHorarios.Count - 1 do
    ckbHorarios.Checked[i] := LerArquivoBool(Arquivo,'HORARIOS',ckbHorarios.Items.Strings[i]);

  bAlterado := False;
end;

procedure TfrmActiveBackup.edtNomeKeyPress(Sender: TObject; var Key: Char);
begin
  {Bloquendo Caracteres Invalidos}
  if (key in ['\','/',':','*','?','"','<','>','|']) then
    key := #0;
end;

procedure TfrmActiveBackup.AbrirBackup1Click(Sender: TObject);
begin
  if SalvaAlteracao then //Verifica e salva se necessrio as alteraes
  begin
    frmDlgArquivos := TfrmDlgArquivos.Create(nil);
    try
      if frmDlgArquivos.ShowModal = mrOK then
      begin
        if sArquivoAberto <>  frmDlgArquivos.flbArquivos.FileName then
        begin
          sArquivoAberto := frmDlgArquivos.flbArquivos.FileName;
          if sArquivoAberto <> '' then
            CarregaArquivo(sArquivoAberto);
        end;
      end;
    finally
      frmDlgArquivos.Release;
    end;
  end;
end;

Procedure TfrmActiveBackup.AdicionaItem(Caption:String; ListView:TListView);
var
 ListItem: TListItem;
begin
  ListItem := ListView.Items.Add;
  ListItem.Caption := Caption;
end;

procedure TfrmActiveBackup.Alterado(Sender: TObject);
begin
  bAlterado := True;
end;

procedure TfrmActiveBackup.btnAdicionaArquivosClick(Sender: TObject);
begin
  if dlgArquivo.Execute then
  begin
    AdicionaItem(dlgArquivo.FileName, lstOrigens);
    Alterado(nil);
  end;
end;

procedure TfrmActiveBackup.btnAdicionaDiretoriosClick(Sender: TObject);
var
  Dir: String;
begin
  if SelectDirectory('Selecione o diretrio de origem','',Dir) then
  begin
    AdicionaItem(Dir+'\*.*',lstOrigens);
    Alterado(nil);
  end;
end;

procedure TfrmActiveBackup.btnDiretorioClick(Sender: TObject);
var
  Dir: String;
begin
  if SelectDirectory('Selecione o diretrio de destino','',Dir) then
    edtDestino.Text := Dir;
end;

procedure TfrmActiveBackup.btnRemoveClick(Sender: TObject);
begin
  {Removendo o item selecionado no ListView}
  if Assigned(lstOrigens.Selected)  then
  begin
    if Application.MessageBox('Deseja realmente remover o item selecionado ?',
      'Confimao',MB_YESNO+MB_ICONQUESTION) = IDYES then
    begin
      lstOrigens.Selected.Delete;
      Alterado(nil);
    end;
  end else
    Application.MessageBox('Selecione o item que deseja remover.','Ateno',
      MB_ICONINFORMATION);
end;

procedure TfrmActiveBackup.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if not SalvaAlteracao then
    CanClose := false;
end;

procedure TfrmActiveBackup.FormCreate(Sender: TObject);
begin
  sArquivoAberto := '';
  sPath := ExtractFilePath(Application.ExeName);
  bAlterado := False;
  {Se o diretrio dos arquivos de backups no existir ento cria}
  if not DirectoryExists(sPath+'Backups') then
    ForceDirectories(sPath+'Backups');
end;

procedure TfrmActiveBackup.NovoBackup1Click(Sender: TObject);
var
  i:integer;
begin
  if SalvaAlteracao then
  begin
    edtNome.Clear;
    edtDestino.Clear;
    lstOrigens.Items.Clear;
    for i := 0 to ckbSemana.Count - 1 do
      ckbSemana.Checked[i] := false;

    for i := 0 to ckbHorarios.Count - 1 do
      ckbHorarios.Checked[i] := false;

    sArquivoAberto := '';
    bAlterado := False;
  end;
end;

procedure TfrmActiveBackup.Sair1Click(Sender: TObject);
begin
  Close;
end;

function TfrmActiveBackup.SalvaAlteracao:Boolean;
begin
  Result := true;
  if bAlterado then
  begin
    if Application.MessageBox('Deseja salvar as alteraes do arquivo?',
      'Confimao',MB_YESNO+MB_ICONQUESTION) = IDYES then
      Result := SalvarArquivo;
  end;
  if result then
    bAlterado := False;
end;

procedure TfrmActiveBackup.SalvarBackup1Click(Sender: TObject);
begin
  bAlterado := not SalvarArquivo;
end;

function TfrmActiveBackup.SalvarArquivo:Boolean;
Var
  i: Integer;
  Origens, Arquivo: String;
begin
  Result := False;

  if Length(trim(edtNome.Text)) = 0  then
  begin
    Application.MessageBox('Informe o nome do backup.','Ateno',MB_ICONINFORMATION);
    exit;
  end;

  if Length(trim(edtDestino.Text)) = 0  then
  begin
    Application.MessageBox('Informe o destino do backup.','Ateno',MB_ICONINFORMATION);
    exit;
  end else
  if not DirectoryExists(edtDestino.Text) then
  begin
    Application.MessageBox('Diretrio de destino no existe.','Ateno',MB_ICONINFORMATION);
    exit;
  end;

  if lstOrigens.Items.Count = 0  then
  begin
    Application.MessageBox('Informe pelomenos 1 arquivo/diretrio de origem.','Ateno',MB_ICONINFORMATION);
    exit;
  end;

  try
    Result := True;
    Arquivo := sPath +'Backups\'+trim(edtNome.Text) + '.abk';

    {Gravando o nome do Backup}
    GravaArquivoString(Arquivo,'DADOS','Nome', trim(edtNome.Text));

    {Gravando Dia da Ultima Vez que o backup foi executado}
    GravaArquivoString(Arquivo,'DADOS','DiaUltimaExecucao','');

    {Gravando Hora da Ultima Vez que o backup foi executado}
    GravaArquivoString(Arquivo,'DADOS','HoraUltimaExecucao','');

    {Gravando Se o backuo est em andamento}
    GravaArquivoBool(Arquivo,'DADOS','EmExcecuao',False);

    {Gravando o destino no backup}
    GravaArquivoString(Arquivo,'DADOS','Destino', edtDestino.Text);

    {Gravando os arquivos de origem do backup}
    for i := 0 to lstOrigens.Items.Count - 1 do
      Origens := Format('%s %s %s',[Origens, lstOrigens.Items[i].Caption, '|']);

    GravaArquivoString(Arquivo,'DADOS','Origens', Origens);

    {Gravando os dias da semana do backup}
    for i := 0 to ckbSemana.Items.Count - 1 do
      GravaArquivoBool(Arquivo, 'SEMANA', ckbSemana.Items.Strings[i], ckbSemana.Checked[i]);

    {Gravando os horarios do backup}
    for i := 0 to ckbHorarios.Items.Count - 1 do
       GravaArquivoBool(Arquivo, 'HORARIOS', ckbHorarios.Items.Strings[i], ckbHorarios.Checked[i]);

    if (sArquivoAberto <> '') and (UpperCase(sArquivoAberto) <> UpperCase(Arquivo)) then
      DeleteFile(sArquivoAberto);

    sArquivoAberto := Arquivo;
  except On E: Exception do
    begin
      Application.MessageBox(Pchar('Ocorreu um erro ao tentar salvar o arquivo.'+#13+
        'Erro:'+E.Message) ,'Ateno',MB_ICONERROR);
      Result := False;
    end;
  end;
end;

end.
