unit uFuncoes;

interface

Uses IniFiles, SysUtils, Classes;

const
  Semana: array[1..7] of String = ('Domingo','Segunda','Tera','Quarta','Quinta','Sexta','Sbado');

  function LerArquivoBool(FileName:String; Sessao, Identidade:String):Boolean;
  function LerArquivoString(FileName:String; Sessao, Identidade:String):String;
  function QuebraString(var Linha: String): String;
  function ListarArquivos(PathAplicacao: String):TStringList;
  procedure GravaArquivoString(FileName, Sessao, Identidade, Valor:String);
  procedure GravaArquivoBool(FileName, Sessao, Identidade: String; Valor:Boolean);

implementation


{**************************************************************
*  Funo que quebra uma string pelo separador                *
**************************************************************}
function QuebraString(var Linha: String): String;
var
  posicao: Integer;
begin
  Result := '';
  if Linha <> '' then
  begin
    Posicao:=pos('|',Linha);
    if posicao = 0 then
    begin
      Result:=Trim(Linha);
      Linha:='';
    end else
    begin
      Result:=Trim(copy(Linha, 1,  Posicao - 1));
      Linha:=Copy(Linha, posicao + 1, Length(Linha) - posicao);
    end;
  end;
end;

{**************************************************************
*  Funo para ler um valor boolean de um arquivo INI         *
**************************************************************}
function LerArquivoBool(FileName:String; Sessao, Identidade:String):Boolean;
var
  Arq:TIniFile;
begin
  Arq := TIniFile.Create(FileName);
  try
    Result := Arq.ReadBool(Sessao,Identidade,false);
  finally
    FreeAndNil(Arq);
  end;
end;

{**************************************************************
*  Funo para ler uma string de um arquivo INI               *
**************************************************************}
function LerArquivoString(FileName:String; Sessao, Identidade:String):String;
var
  Arq:TIniFile;
begin
  Arq := TIniFile.Create(FileName);
  try
    Result := Arq.ReadString(Sessao,Identidade,'');
  finally
    FreeAndNil(Arq);
  end;
end;

{**************************************************************
*  Funo para gravar um valor boolean de um arquivo INI      *
**************************************************************}
procedure GravaArquivoBool(FileName, Sessao, Identidade: String; Valor:Boolean);
var
  Arq:TIniFile;
begin
  Arq := TIniFile.Create(FileName);
  try
    Arq.WriteBool(Sessao,Identidade,Valor);
  finally
    FreeAndNil(Arq);
  end;
end;

{**************************************************************
*  Funo para gravar uma string de um arquivo INI            *
**************************************************************}
procedure GravaArquivoString(FileName, Sessao, Identidade, Valor:String);
var
  Arq:TIniFile;
begin
  Arq := TIniFile.Create(FileName);
  try
    Arq.WriteString(Sessao,Identidade,Valor);
  finally
    FreeAndNil(Arq);
  end;
end;

{**************************************************************
*  Funo para listar todos arquivos ABK de um diretrio      *
**************************************************************}
function ListarArquivos(PathAplicacao: String):TStringList;
var
  F: TSearchRec;
  Ret: Integer;
begin
  Result := TStringList.Create;
  {FindFirst procura o diretrio especificado, retorna "0" se o diretrio foi
  encontrado, o resultado  retornado no parmetro de F}
  Ret := FindFirst(PathAplicacao + 'Backups\*.abk', faAnyFile, F);
  try
    while Ret = 0 do
    begin
      Result.Add(PathAplicacao + 'Backups\'+F.Name);
      Ret := FindNext(F);
    end;
  finally
    FindClose(F);
  end;
end;

end.
