unit uSrvActiveBackup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, SvcMgr, Dialogs,
  uthrMonitoraBackups;


type
  TActiveBackup = class(TService)
    procedure ServiceStart(Sender: TService; var Started: Boolean);
    procedure ServiceStop(Sender: TService; var Stopped: Boolean);
    procedure ServicePause(Sender: TService; var Paused: Boolean);
    procedure ServiceCreate(Sender: TObject);
    procedure ServiceContinue(Sender: TService; var Continued: Boolean);
  private
    { Private declarations }
     ThreadMonitora: TthrMonitoraBackups;
  public
    procedure GravarEventView(Msg: AnsiString; Tipo: Char);
    function GetServiceController: TServiceController; override;
    { Public declarations }
  end;

var
  ActiveBackup: TActiveBackup;

implementation

{$R *.DFM}

procedure ServiceController(CtrlCode: DWord); stdcall;
begin
  ActiveBackup.Controller(CtrlCode);
end;

function TActiveBackup.GetServiceController: TServiceController;
begin
  Result := ServiceController;
end;

procedure TActiveBackup.ServiceCreate(Sender: TObject);
begin
  {Criando a Thread que ficar monitorando os Backup's}
  ThreadMonitora := TthrMonitoraBackups.Create(True);
end;

procedure TActiveBackup.ServiceStart(Sender: TService;
  var Started: Boolean);
begin
  {Inciando a Thread}
  ThreadMonitora.Resume;
end;

procedure TActiveBackup.ServiceStop(Sender: TService;
  var Stopped: Boolean);
begin
  {Pausando a Terminando}
  ThreadMonitora.Terminate;
end;

procedure TActiveBackup.ServicePause(Sender: TService;
  var Paused: Boolean);
begin
  {Pausando a Thread}
  ThreadMonitora.Suspend;
end;

procedure TActiveBackup.ServiceContinue(Sender: TService;
  var Continued: Boolean);
begin
  {Inciando a Thread}
  ThreadMonitora.Resume;
end;

{Grava Informae no EventView}
procedure TActiveBackup.GravarEventView(Msg: AnsiString; Tipo: Char);
begin
  case Tipo of
    'E':LogMessage(Msg,EVENTLOG_ERROR_TYPE,0,0);
    'W':LogMessage(Msg,EVENTLOG_WARNING_TYPE,0,0);
    'I':LogMessage(Msg,EVENTLOG_INFORMATION_TYPE,0,0);
   end;
end;

end.
