unit uThrActiveBackup;

interface

uses
   Classes, SysUtils, ZipMstr, DateUtils;

type
  TthrActiveBackup = class(TThread)
  private
    FFileNameBackup:String;
    procedure SetFileNameBackup(FileName: String);
    procedure EfetuarBackup(FileName:String);
  protected
    procedure Execute; override;
  published
    property FileNameBackup: string read FFileNameBackup write SetFileNameBackup;
  end;

implementation

uses UFuncoes, uSrvActiveBackup;

{ TthrActiveBackup }

procedure TthrActiveBackup.Execute;
begin
  FreeOnTerminate := True;
  EfetuarBackup(FFileNameBackup);
  Terminate;
end;

procedure TthrActiveBackup.SetFileNameBackup(FileName: String);
begin
  FFileNameBackup := FileName;
end;

procedure TthrActiveBackup.EfetuarBackup(FileName:String);
var
  ZP: TZipMaster;
  Origens,
  Arquivo,
  NomeBackup,
  Destino:String;
  HoraInicio: String;
begin
  ZP := TZipMaster.Create(nil);
  try
    try
      ZP.AddOptions := [AddDirNames]; //Mantem a estrutura de pastas
      Destino := LerArquivoString(FileName,'DADOS', 'Destino');
      Origens := LerArquivoString(FileName,'DADOS','Origens');
      ZP.FSpecArgs.Clear;
      while Length(Origens) > 0 do
      begin
        Arquivo := QuebraString(Origens);
        if Pos('\*.*',Arquivo) > 0 then //Se for um diretrio inteiro
        begin
          if not DirectoryExists(Copy(Arquivo, 1,Pos('\*.*',Arquivo)-1)) then
          begin
            ActiveBackup.GravarEventView('Diretrio '+Arquivo+' no existe','W');
            Continue;
          end;
        end else
        begin
          if not FileExists(Arquivo) then
          begin
            ActiveBackup.GravarEventView('Arquivo '+Arquivo+' no existe','W');
            Continue;
          end;
        end;
        ZP.FSpecArgs.Add(Arquivo);
      end;
      ZP.TempDir := Destino;
      NomeBackup := LerArquivoString(FileName,'DADOS', 'Nome'); //Nome do Backup
      ZP.SFXDefaultDir := Destino;
      {Nome do Backup}
      ZP.ZipFileName := ZP.SFXDefaultDir + '\'+NomeBackup + FormatDateTime('ddmmyyyyhhmmss',Now)+'.zip'; //Nome do Arquivo

      HoraInicio := FormatDateTime('hh:mm:ss',Now);

      {Caso tenha algum arquivo para ser compactado}
      if ZP.FSpecArgs.Count > 0 then
        ZP.Add;

      {Gravando informao no EventView}
      ActiveBackup.GravarEventView('Backup '+NomeBackup+' inciado s '+HoraInicio+
       ' e finalizado s '+FormatDateTime('hh:mm:ss',Now),'I');

      {Atualizando informaes no Arquivo ABK}
      GravaArquivoBool(FileName,'DADOS','EmExecucao',False);
      GravaArquivoString(FileName,'DADOS','DiaUltimaExecucao',Semana[DayOfWeek(Now)]);
      GravaArquivoString(FileName,'DADOS','HoraUltimaExecucao',FormatFloat('00',HourOf(Now))+':00');

    except on E: Exception do
      ActiveBackup.GravarEventView('Ocorreu o seguinte erro duarante a execuo '+E.Message,'E');
    end;
  finally
    FreeAndNil(ZP);
  end;
end;

end.
