unit uThrMonitoraBackups;

interface

uses
  Classes, Forms, SysUtils, DateUtils, uThrActiveBackup;

type
  TthrMonitoraBackups = class(TThread)
  private
    FBackups: Array of TthrActiveBackup;
  protected
    procedure Execute; override;
  end;

implementation

Uses uFuncoes, uSrvActiveBackup;

{ TthrMonitoraBackups }

procedure TthrMonitoraBackups.Execute;
var
  i:Integer;
  DiaUltimaExecucao, HoraUltimaExecucao:String;
  EmExecucao:Boolean;
  Arquivos: TStringList;
begin
  FreeOnTerminate := True;
  Arquivos := TStringList.Create;
  try
    try
      while not Terminated do
      begin
        Sleep(1000);
        Arquivos := ListarArquivos(ExtractFilePath(Application.ExeName));
        SetLength(FBackups, Arquivos.Count);
        for i := 0 to Pred(Arquivos.Count) do
        begin
          HoraUltimaExecucao := LerArquivoString(Arquivos.Strings[i],'DADOS','HoraUltimaExecucao');
          DiaUltimaExecucao := LerArquivoString(Arquivos.Strings[i],'DADOS','DiaUltimaExecucao');
          EmExecucao := LerArquivoBool(Arquivos.Strings[i],'DADOS','EmExecucao');
          if LerArquivoBool(Arquivos.Strings[i],'SEMANA',Semana[DayOfWeek(Now)]) and
            LerArquivoBool(Arquivos.Strings[i],'HORARIOS',FormatFloat('00',HourOf(now))+':00') then
          begin
            if ((DiaUltimaExecucao+HoraUltimaExecucao) <> (Semana[DayOfWeek(Now)] + FormatFloat('00',HourOf(now))+':00')) and
              (not EmExecucao) then
            begin
              GravaArquivoBool(Arquivos.Strings[i],'DADOS','EmExecucao',True);
              FBackups[i] := TthrActiveBackup.Create(True);
              FBackups[i].FileNameBackup := Arquivos.Strings[i];
              FBackups[i].Resume;
            end;
          end;
        end;
      end;
    except on E: Exception do
      ActiveBackup.GravarEventView('Ocorreu o seguinte erro duarante a execuo '+E.Message,'E');
    end;
  finally
    FreeAndNil(Arquivos);
  end;
end;


end.
