unit UImpressoraECF;

interface

uses
  UItem, SysUtils,Forms, Classes;

type
 TFormaPagtos = (fpDinheiro, fpCheque, fpCartao, fpTicket, fpFiado);

 TTipoImpressoras = (tiNone, tiBematech, tiDaruma);

 TImpressoraECF = class
 private
   FLogOutput: TStrings;
   FTipoImpressora: TTipoImpressoras;
 protected
   procedure AddLogOutput(const Text: String);

   // Funes Bematech
   procedure  IniciarVendaBematech;
   procedure  VenderItemBematech(const AItem: TItem);
   procedure  FinalizarVendaBematech(const FormaPagto: TFormaPagtos);

   // Funes Daruma
   procedure  IniciarVendaDaruma;
   procedure  VenderItemDaruma(const AItem: TItem);
   procedure  FinalizarVendaDaruma(const FormaPagto: TFormaPagtos);
 public
   // Funes Gerais
   procedure  IniciarVenda;
   procedure  VenderItem(const AItem: TItem);
   procedure  FinalizarVenda(const FormaPagto: TFormaPagtos);

   procedure RegisterLogOutput(const LogOutput: TStrings);
   procedure UnRegisterLogOutput;
   property  TipoImpressora: TTipoImpressoras read FTipoImpressora write FTipoImpressora;
 end;

var
  FormaPagtoValues: Array[TFormaPagtos] of String =
   ('Dinheiro',
    'Cheque',
    'Cartao',
    'Ticket',
    'Fiado'
   );

  FormaPagtoAtalhos: Array[TFormaPagtos] of String =
   ('F5',
    'F6',
    'F7',
    'F8',
    'F9'
   );

  TipoImpressorasValues: Array[TTipoImpressoras] of String =
   ('Nenhuma',
    'Bematech MP-20 Modelos I e II',
    'Daruma'
   );

implementation

{ TImpressoraECF }

procedure TImpressoraECF.AddLogOutput(const Text: String);
begin
  if Assigned(FLogOutput) then begin
    FLogOutput.Text := FLogOutput.Text + #13#10 + Text;
    FLogOutput.Add('');
  end;
end;

procedure TImpressoraECF.FinalizarVenda(const FormaPagto: TFormaPagtos);
begin
  case FTipoImpressora of
    tiNone: raise Exception.Create('Impressora ECF no configurada');
    tiBematech: FinalizarVendaBematech(FormaPagto);
    tiDaruma: FinalizarVendaDaruma(FormaPagto);
  end;
end;

procedure TImpressoraECF.FinalizarVendaBematech(const FormaPagto: TFormaPagtos);
begin
  AddLogOutput(Format('Efetuando forma de pagamento %s na impressora Fiscal Bematech...',[FormaPagtoValues[FormaPagto]]) + SLineBreak +
                      'Finalizando venda na impressora fiscal Bematech...');
end;

procedure TImpressoraECF.FinalizarVendaDaruma(const FormaPagto: TFormaPagtos);
begin
  AddLogOutput(Format('Efetuando forma de pagamento %s na impressora Fiscal Daruma...',[FormaPagtoValues[FormaPagto]]) + SLineBreak +
                      'Finalizando venda na impressora fiscal Daruma...');
end;

procedure TImpressoraECF.IniciarVenda;
begin
  case FTipoImpressora of
   tiNone: raise Exception.Create('Impressora ECF no configurada');
   tiBematech: IniciarVendaBematech;
   tiDaruma: IniciarVendaDaruma;
  end;
end;

procedure TImpressoraECF.IniciarVendaBematech;
begin
  AddLogOutput('Abrindo Cupom na impressora Fiscal Bematech...');
end;

procedure TImpressoraECF.IniciarVendaDaruma;
begin
  AddLogOutput('Abrindo Cupom na impressora Fiscal Daruma...');
end;

procedure TImpressoraECF.RegisterLogOutput(const LogOutput: TStrings);
begin
  FLogOutput := LogOutput;
end;

procedure TImpressoraECF.UnRegisterLogOutput;
begin
 FLogOutput := nil;
end;

procedure TImpressoraECF.VenderItem(const AItem: TItem);
begin
  case FTipoImpressora of
    tiNone: raise Exception.Create('Impressora ECF no configurada');
    tiBematech: VenderItemBematech(AItem);
    tiDaruma: VenderItemDaruma(AItem);
  end;
end;


procedure TImpressoraECF.VenderItemBematech(const AItem: TItem);
begin
   AddLogOutput('Vendendo item na impressora Fiscal Bematech...' + sLineBreak +
                Format('Codigo: %s',[AItem.Codigo]) + sLineBreak +
                Format('Descricao: %s',[AItem.Descricao])  + sLineBreak +
                Format('Valor: %s',[AItem.ValorAsString])
               );
end;

procedure TImpressoraECF.VenderItemDaruma(const AItem: TItem);
begin
   AddLogOutput('Vendendo item na impressora Fiscal Daruma...' + sLineBreak +
                Format('Codigo: %s',[AItem.Codigo]) + sLineBreak +
                Format('Descricao: %s',[AItem.Descricao])  + sLineBreak +
                Format('Valor: %s',[AItem.ValorAsString])
               );
end;

end.
