unit UfrmCaixa;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ToolWin, ComCtrls, Menus, UHardware, UItem, UImpressoraECF,
  StdCtrls, ExtCtrls;
type
  // situaes do Caixa
  TCaixaStatus = (csNone, csInicio, csVenda);

  TFrmCaixa = class(TForm)
    StbCaixa: TStatusBar;
    MainMenu1: TMainMenu;
    mnuCaixa: TMenuItem;
    mnuIniciarVenda: TMenuItem;
    mnuFinalizarVenda: TMenuItem;
    N1: TMenuItem;
    Sair1: TMenuItem;
    mnuHardware: TMenuItem;
    mnuImpressoras: TMenuItem;
    memLog: TMemo;
    Panel1: TPanel;
    edtItem: TEdit;
    Label1: TLabel;
    procedure Sair1Click(Sender: TObject);
    procedure mnuIniciarVendaClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure edtItemKeyPress(Sender: TObject; var Key: Char);
  private
    // Valor Total da Venda
    FTotal: Currency;

    // Lista de itens
    FItems: TItems;

    FCaixaStatus: TCaixaStatus;
    procedure SelectImpressora(const Menu: TMenuItem);
    procedure VenderItem;
    procedure mnuFinalizarVendaClick(Sender: TObject);
    procedure MnuImpressoraClick(Sender: TObject);
    procedure CarregarMenuImpressoras;
    procedure CarregarMenuFinalizarVenda;
    procedure UpdateTotal;
  end;

var
  FrmCaixa: TFrmCaixa;

implementation


{$R *.dfm}

procedure TFrmCaixa.Sair1Click(Sender: TObject);
begin
   Application.Terminate;
end;

procedure TFrmCaixa.SelectImpressora(const Menu: TMenuItem);
begin
  // Seta tipo de impressora
  Hardware.TipoImpressora := TTipoImpressoras(Menu.Tag);
  // Registra propriedade Lines do memo como output para o log da impressora
  Hardware.ImpressoraECF.RegisterLogOutput(memLog.Lines);
  //Atualiza Status Bar
  StbCaixa.Panels[0].Text := 'Impressora: ' + TipoImpressorasValues[Hardware.TipoImpressora];
end;

procedure TFrmCaixa.mnuIniciarVendaClick(Sender: TObject);
begin
  if FCaixaStatus in [csVenda] then
   raise Exception.Create('Finalize a venda atual antes de iniciar uma nova');
  memLog.Clear;
  Hardware.ImpressoraECF.IniciarVenda;
  FTotal := 0;
  FCaixaStatus := csInicio;
  UpdateTotal;
end;

procedure TFrmCaixa.mnuFinalizarVendaClick(Sender: TObject);
begin
  if FCaixaStatus in [csNone, csInicio] then
    raise Exception.Create(' necessrio vender pelo menos 1 item antes de finalizar.');
 Hardware.ImpressoraECF.FinalizarVenda(TFormaPagtos((Sender as TMenuITem).Tag));
 FCaixaStatus := csNone;
end;

procedure TFrmCaixa.CarregarMenuImpressoras;
var
  i: integer;
  Menu: TMenuItem;
  Description: string;
  PackageFileNameIni: String;
begin
  mnuImpressoras.Clear;

  // Varre a lista de impressoras e cria os menus
  for i := 0 to Length(TipoImpressorasValues) - 1 do begin

    // Obtem descrio do menu a partir da package
    Description := TipoImpressorasValues[TTipoImpressoras(i)];

    if Description <> '' then begin
      Menu := TMenuItem.Create(mnuImpressoras);
      Menu.Caption := Description;
      Menu.OnClick := MnuImpressoraClick;
      Menu.RadioItem := true;

      // grava no tag o tipo da Impressora
      Menu.Tag := i;

      mnuImpressoras.Add(Menu);
    end;
  end;
end;


procedure TFrmCaixa.CarregarMenuFinalizarVenda;
var
  i: integer;
  Menu: TMenuItem;
  FormaPagto: TFormaPagtos;
begin
  mnuFinalizarVenda.Clear;

  // Varre a lista de packages e cria os menus
  for i := 0 to Length(FormaPagtoValues) - 1 do begin

      FormaPagto := TFormaPagtos(i);
      Menu := TMenuItem.Create(mnuImpressoras);
      Menu.Caption := FormaPagtoValues[FormaPagto];
      Menu.ShortCut := TextToShortCut(FormaPagtoAtalhos[FormaPagto]);
      Menu.OnClick := mnuFinalizarVendaClick;

      // grava no tag do menu o indice da forma de pagamento
      Menu.Tag := i;

      mnuFinalizarVenda.Add(Menu);
  end;
end;

procedure TFrmCaixa.MnuImpressoraClick(Sender: TObject);
begin
  if FCaixaStatus <> csNone then
    raise Exception.create('Finalize a venda atual antes de trocar de impressora');

  SelectImpressora(Sender as TMenuItem);

  (Sender as TMenuItem).Checked := true;

  FTotal := 0;
  memLog.Clear;

  UpdateTotal;
end;

procedure TFrmCaixa.FormCreate(Sender: TObject);
begin
  // Inicializa Menus
  CarregarMenuImpressoras;
  CarregarMenuFinalizarVenda;

  // Carrega lista de itens do arquivo de dados
  FItems := TItems.Create;
  FItems.LoadItemsFromDisk('Items.dat');

  FTotal := 0;
  FCaixaStatus := csNone;
end;


procedure TFrmCaixa.FormDestroy(Sender: TObject);
begin
  if Assigned(FItems) then
    FItems.Free;
end;

procedure TFrmCaixa.VenderItem;
var
  Item: TItem;
begin
  if FCaixaStatus in [csNone] then
    raise Exception.Create(' necessrio iniciar uma venda.');

  if edtItem.Text <> '' then begin
     Item := FItems.FindItemByCodigo(edtItem.Text);
     if Assigned(Item) then begin
       hardware.ImpressoraECF.VenderItem(Item);
       FTotal := FTotal + Item.Valor;
       FCaixaStatus := csVenda;
       UpdateTotal;
       edtItem.Clear;
     end else begin
      edtItem.SelectAll;
      raise Exception.Create('Item ' + edtItem.Text + ' no localizado.');
     end;
  end;
end;

procedure TFrmCaixa.edtItemKeyPress(Sender: TObject; var Key: Char);
begin
  if key = #13 then
    VenderItem;
end;

procedure TFrmCaixa.UpdateTotal;
begin
  StbCaixa.Panels[1].Text := 'Sub Total: ' + FormatCurr(',0.00',FTotal);
end;

end.
