unit UHardware;

interface

uses
 SysUtils, UImpressoraECF, UImpressoraECFBematech, UImpressoraECFDaruma;

type
 THardware = class
 private
    FImpressoraECF: TImpressoraECF;
    FTipoImpressora: TTipoImpressoras;
    function GetImpressoraECF: TImpressoraECF;
    procedure SetTipoImpressora(const Value: TTipoImpressoras);
 protected
   function ImpressoraECFFactory: TImpressoraECF;
 public
  constructor Create;
  destructor Destroy; override;
  property  ImpressoraECF: TImpressoraECF read GetImpressoraECF;
  property  TipoImpressora: TTipoImpressoras read FTipoImpressora write SetTipoImpressora;
 end;

var
  Hardware: THardware;

implementation


{ THardware }

destructor THardware.Destroy;
begin
  if Assigned(FImpressoraECF) then
   FreeAndNil(FImpressoraECF);
end;

constructor THardware.Create;
begin
  FImpressoraECF := nil;
end;

function THardware.GetImpressoraECF: TImpressoraECF;
begin
  if not Assigned(FImpressoraECF) then
    raise Exception.Create('Impressora ECF no configurada');
  Result := FImpressoraECF;
end;

function THardware.ImpressoraECFFactory: TImpressoraECF;
begin
  case TipoImpressora of
    tiNone: Result := nil; 
    tiBematech: Result := TImpressoraECFBematech.Create;
    tiDaruma: Result := TImpressoraECFDaruma.Create;
    else
     raise exception.Create('Tipo de Impressora ECF no definido');
  end;
end;

procedure THardware.SetTipoImpressora(const Value: TTipoImpressoras);
begin
  FTipoImpressora := Value;
  if Assigned(FImpressoraECF) then
    FreeAndNil(FImpressoraECF);
   FImpressoraECF := ImpressoraECFFactory; 
end;

initialization
  Hardware := THardware.Create;

finalization
  if Assigned(Hardware) then
    FreeAndNil(Hardware);
end.
