unit UImpressoraECF;

interface

uses
  UItem, SysUtils,Forms, Classes;

type
 TFormaPagtos = (fpDinheiro, fpCheque, fpCartao, fpTicket, fpFiado);

 TTipoImpressoras = (tiNone, tiBematech, tiDaruma);

 TImpressoraECF = class
 private
   FLogOutput: TStrings;
 protected
   procedure AddLogOutput(const Text: String);
 public
   // Funes Gerais
   procedure  IniciarVenda; virtual;
   procedure  VenderItem(const AItem: TItem); virtual;
   procedure  FinalizarVenda(const FormaPagto: TFormaPagtos); virtual;

   procedure RegisterLogOutput(const LogOutput: TStrings);
   procedure UnRegisterLogOutput;
 end;

 EMetodoNaoImplementado = class(Exception)
 public
   constructor Create(const AClassName: String; const AMetodoName: String);
 end;


var
  FormaPagtoValues: Array[TFormaPagtos] of String =
   ('Dinheiro',
    'Cheque',
    'Cartao',
    'Ticket',
    'Fiado'
   );

  FormaPagtoAtalhos: Array[TFormaPagtos] of String =
   ('F5',
    'F6',
    'F7',
    'F8',
    'F9'
   );

  TipoImpressorasValues: Array[TTipoImpressoras] of String =
   ('Nenhuma',
    'Bematech MP-20 Modelos I e II',
    'Daruma'
   );

implementation


{ TImpressoraECF }

procedure TImpressoraECF.AddLogOutput(const Text: String);
begin
  if Assigned(FLogOutput) then begin
    FLogOutput.Text := FLogOutput.Text + #13#10 + Text;
    FLogOutput.Add('');
  end;
end;

procedure TImpressoraECF.FinalizarVenda(const FormaPagto: TFormaPagtos);
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'FinalizarVenda');
end;

procedure TImpressoraECF.IniciarVenda;
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'IniciarVenda');
end;

procedure TImpressoraECF.RegisterLogOutput(const LogOutput: TStrings);
begin
  FLogOutput := LogOutput;
end;

procedure TImpressoraECF.UnRegisterLogOutput;
begin
 FLogOutput := nil;
end;

procedure TImpressoraECF.VenderItem(const AItem: TItem);
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'VenderItem');
end;


{ EMetodoNaoImplementado }

constructor EMetodoNaoImplementado.Create(const AClassName, AMetodoName: String);
const
  AMessageError = 'Mtodo %1:s no implementado na classe %0:s';
begin
  inherited Create(Format(AMessageError,[AClassName,AMetodoName]));
end;

end.
