unit UImpressoraECFBematech;

interface

uses
  Dialogs, UItem, UImpressoraECF, SysUtils;

Type
  TImpressoraECFBematech = class(TImpressoraECF)
  public
   procedure IniciarVenda; override;
   procedure VenderItem(const AItem: TItem); override;
   procedure FinalizarVenda(const FormaPagto: TFormaPagtos); override;
  end;

implementation

{ TImpressoraECFBematech }

procedure TImpressoraECFBematech.FinalizarVenda(const FormaPagto: TFormaPagtos);
begin
  AddLogOutput(Format('Efetuando forma de pagamento %s na impressora Fiscal Bematech...',[FormaPagtoValues[FormaPagto]]) + SLineBreak +
  'Finalizando venda na impressora fiscal Bematech...');
end;

procedure TImpressoraECFBematech.IniciarVenda;
begin
  AddLogOutput('Abrindo Cupom na impressora Fiscal Bematech...');
end;

procedure TImpressoraECFBematech.VenderItem(const AItem: TItem);
begin
  AddLogOutput('Vendendo item na impressora Fiscal Bematech...' + sLineBreak +
                Format('Codigo: %s',[AItem.Codigo]) + sLineBreak +
                Format('Descricao: %s',[AItem.Descricao])  + sLineBreak +
                Format('Valor: %s',[AItem.ValorAsString])
               );
end;

end.
