unit UImpressoraECFDaruma;

interface

uses
  Dialogs, UItem, UImpressoraECF, SysUtils;

Type
  TImpressoraECFDaruma = class(TImpressoraECF)
  public
   procedure IniciarVenda; override;
   procedure VenderItem(const AItem: TItem); override;
   procedure FinalizarVenda(const FormaPagto: TFormaPagtos); override;
  end;

implementation

uses Classes;

{ TImpressoraECFDaruma }

procedure TImpressoraECFDaruma.FinalizarVenda(const FormaPagto: TFormaPagtos);
begin
  AddLogOutput(Format('Efetuando forma de pagamento %s na impressora Fiscal Daruma...',[FormaPagtoValues[FormaPagto]]) + SLineBreak +
  'Finalizando venda na impressora fiscal Daruma...');
end;

procedure TImpressoraECFDaruma.IniciarVenda;
begin
  AddLogOutput('Abrindo Cupom na impressora Fiscal Daruma...');
end;

procedure TImpressoraECFDaruma.VenderItem(const AItem: TItem);
begin
  AddLogOutput('Vendendo item na impressora Fiscal Daruma...' + sLineBreak +
                Format('Codigo: %s',[AItem.Codigo]) + sLineBreak +
                Format('Descricao: %s',[AItem.Descricao])  + sLineBreak +
                Format('Valor: %s',[AItem.ValorAsString])
               );
end;

end.
