unit UHardware;

interface

uses
 UItem, SysUtils, UImpressoraECF, UPackage, Inifiles;

const
  ImpressorasPath = 'Hardware\Impressoras\';

type
 THardware = class
 private
    FImpressoraECF: TImpressoraECF;
    FImpressoraECFPackages: TPackages;
    FImpressoraECFFactory: TImpressoraECFFactory;
    function GetImpressoraECF: TImpressoraECF;
    function GetImpressoraECFFactory: TImpressoraECFFactory;
 public
  constructor Create;
  destructor Destroy; override;
  property  ImpressoraECFPackages: TPackages read FImpressoraECFPackages;
  procedure SaveImpressoraPackageToIni(const PackageFileName: String);
  function  LoadImpressoraPackageFromIni: String;
  procedure SetImpressoraECFFromPackage(const ImpressoraPackage: TImpressoraPackage);
  property  ImpressoraECF: TImpressoraECF read GetImpressoraECF;
  property  ImpressoraECFFactory: TImpressoraECFFactory read GetImpressoraECFFactory;
 end;

var
  Hardware: THardware;


implementation

{ THardware }


constructor THardware.Create;
begin
  FImpressoraECF := nil;
  FImpressoraECFFactory := nil;
  FImpressoraECFPackages := TPackages.Create(TImpressoraPackage,ExtractFilePath(ParamStr(0)) + 'Hardware\Impressoras\');
  FImpressoraECFPackages.LoadPackagesFromDisk;

end;

destructor THardware.Destroy;
begin
  if Assigned(FImpressoraECF) then
   FreeAndNil(FImpressoraECF);

  if Assigned(FImpressoraECFPackages) then
    FreeAndNil(FImpressoraECFPackages);
end;

function THardware.GetImpressoraECF: TImpressoraECF;
begin
  if not Assigned(FImpressoraECF) then
    raise Exception.Create('Impressora ECF no configurada no sistema');

  Result := FImpressoraECF;
end;


function THardware.GetImpressoraECFFactory: TImpressoraECFFactory;
begin
  if not Assigned(FImpressoraECFFactory) then
    raise Exception.Create('Impressora ECF no configurada no sistema');

  Result := FImpressoraECFFactory;
   
end;

function THardware.LoadImpressoraPackageFromIni: String;
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(ImpressorasPath + 'config.ini');
  try
    Result := Ini.ReadString('Impressora','Package','');
  finally
   Ini.Free;
  end;
end;

procedure THardware.SaveImpressoraPackageToIni(const PackageFileName: String);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(ImpressorasPath + 'config.ini');
  try
    Ini.WriteString('Impressora','Package',PackageFileName);
  finally
   Ini.Free;
  end;
end;

procedure THardware.SetImpressoraECFFromPackage(const ImpressoraPackage: TImpressoraPackage);
begin
  // libera factory se j exixtir uma
  if Assigned(FImpressoraECFFactory) then
    FreeAndNil(FImpressoraECFFactory);

  // obtem factory a partir da package
  FImpressoraECFFactory := ImpressoraPackage.GetImpressoraFactory;
  if Assigned(FImpressoraECFFactory) then begin

    // libera impressora ECF se j existir uma
    if Assigned(FImpressoraECF) then
      FreeAndNil(FImpressoraECF);

    // instancia impressora ECF a partir da factory
    FImpressoraECF := ImpressoraECFFactory.CreateImpressoraECF;
  end else
    raise exception.CreateFmt('no foi possivel inicializar impressora ECF a partir da package %s',
                              [ImpressoraPackage.PackageFileName]);
end;


initialization
  Hardware := THardware.Create;


finalization
  if Assigned(Hardware) then
    FreeAndNil(Hardware);


end.
