unit UImpressoraECF;

interface

uses
  UItem, SysUtils,Forms, Classes, UPackage;

type
 TFormaPagtos = (fpDinheiro, fpCheque, fpCartao, fpTicket, fpFiado);

 TTipoImpressoras = (tiNone, tiBematech, tiDaruma);

 TImpressoraECF = class
 private
   FLogOutput: TStrings;
 protected
   procedure AddLogOutput(const Text: String);
 public
   // Funes Gerais
   procedure  IniciarVenda; virtual;
   procedure  VenderItem(const AItem: TItem); virtual;
   procedure  FinalizarVenda(const FormaPagto: TFormaPagtos); virtual;

   procedure RegisterLogOutput(const LogOutput: TStrings);
   procedure UnRegisterLogOutput;
 end;

 TImpressoraECFFactory = class
 protected
   function GetDescription: String; virtual;
 public
   property Description: String read GetDescription;
   function CreateImpressoraECF: TImpressoraECF; virtual;
   function CreateConfigurationForm: TForm; virtual;
 end;

 TImpressoraECFFactoryClass = class of TImpressoraECFFactory;

 TImpressoraPackage = class(TPackage)
 private
 protected
 public
   function ReadImpressoraDescription: String;
   function GetImpressoraFactory: TImpressoraECFFactory;
 end;


 EMetodoNaoImplementado = class(Exception)
 public
   constructor Create(const AClassName: String; const AMetodoName: String);
 end;


var
  FormaPagtoValues: Array[TFormaPagtos] of String =
   ('Dinheiro',
    'Cheque',
    'Cartao',
    'Ticket',
    'Fiado'
   );

  FormaPagtoAtalhos: Array[TFormaPagtos] of String =
   ('F5',
    'F6',
    'F7',
    'F8',
    'F9'
   );

  TipoImpressorasValues: Array[TTipoImpressoras] of String =
   ('Nenhuma',
    'Bematech MP-20 Modelos I e II',
    'Daruma'
   );

implementation


{ TImpressoraECF }

procedure TImpressoraECF.AddLogOutput(const Text: String);
begin
  if Assigned(FLogOutput) then begin
    FLogOutput.Text := FLogOutput.Text + #13#10 + Text;
    FLogOutput.Add('');
  end;
end;

procedure TImpressoraECF.FinalizarVenda(const FormaPagto: TFormaPagtos);
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'FinalizarVenda');
end;

procedure TImpressoraECF.IniciarVenda;
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'IniciarVenda');
end;

procedure TImpressoraECF.RegisterLogOutput(const LogOutput: TStrings);
begin
  FLogOutput := LogOutput;
end;

procedure TImpressoraECF.UnRegisterLogOutput;
begin
 FLogOutput := nil;
end;

procedure TImpressoraECF.VenderItem(const AItem: TItem);
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'VenderItem');
end;


{ EMetodoNaoImplementado }

constructor EMetodoNaoImplementado.Create(const AClassName, AMetodoName: String);
const
  AMessageError = 'Mtodo %1:s no implementado na classe %0:s';
begin
  inherited Create(Format(AMessageError,[AClassName,AMetodoName]));
end;

{ TImpressoraECFFactory }

function TImpressoraECFFactory.CreateConfigurationForm: TForm;
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'CreateConfigurationForm');
end;

function TImpressoraECFFactory.CreateImpressoraECF: TImpressoraECF;
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'CreateImpressoraECF');
end;

function TImpressoraECFFactory.GetDescription: String;
begin
  raise EMetodoNaoImplementado.Create(Self.ClassName,'GetDescription');
end;

{ TImpressoraPackage }

function TImpressoraPackage.ReadImpressoraDescription: String;
var
  ImpressoraECFFactory: TImpressoraECFFactory;
begin
  ImpressoraECFFactory := GetImpressoraFactory;
  try
    if Assigned(ImpressoraECFFactory) then
      Result := ImpressoraECFFactory.Description;
  finally
    if assigned(ImpressoraECFFactory) then
      FreeAndNil(ImpressoraECFFactory);

    if Loaded then UnLoadPackage;
  end;
end;

function TImpressoraPackage.GetImpressoraFactory: TImpressoraECFFactory;
var
  ImpressoraECFFactoryClass: TImpressoraECFFactoryClass;
  Index: Integer;
  PackageName: String;
begin
  Result := nil;

  // Carrega package para a memria, o que inicializa o registro da factory
  if not Loaded then LoadPackage;

    if Loaded then begin
      PackageName := ExtractFileName(PackageFileName);

      //obtem a factory registrada pela inicializao da package
      Index := RegisteredPackages.IndexOf(PackageName);
      if Index <> -1 then begin
        ImpressoraECFFactoryClass := TImpressoraECFFactoryClass(RegisteredPackages.Objects[Index]);
        if Assigned(ImpressoraECFFactoryClass) then

          // instancia o objeto da factory com a referencia de classe obtida da package
          Result := ImpressoraECFFactoryClass.Create;

      end;

    end;
end;

end.
