unit UImpressoraECFBematech;

interface

uses
  UItem, UImpressoraECF, SysUtils, UPackage;

const
  PackageName = 'ImpressoraECFBematech.bpl';


Type
  TImpressoraECFBematech = class(TImpressoraECF)
  public
   procedure IniciarVenda; override;
   procedure VenderItem(const AItem: TItem); override;
   procedure FinalizarVenda(const FormaPagto: TFormaPagtos); override;
  end;

  TImpressoraECFBematechFactory = class(TImpressoraECFFactory)
  public
   function GetDescription: String; override;
   function CreateImpressoraECF: TImpressoraECF; override;
  end;


implementation

uses Classes;

{ TImpressoraECFBematech }

procedure TImpressoraECFBematech.FinalizarVenda(const FormaPagto: TFormaPagtos);
begin
  AddLogOutput(Format('Efetuando forma de pagamento %s na impressora Fiscal Bematech...',[FormaPagtoValues[FormaPagto]]) + SLineBreak +
  'Finalizando venda na impressora fiscal Bematech...');
end;

procedure TImpressoraECFBematech.IniciarVenda;
begin
  AddLogOutput('Abrindo Cupom na impressora Fiscal Bematech...');
end;

procedure TImpressoraECFBematech.VenderItem(const AItem: TItem);
begin
  AddLogOutput('Vendendo item na impressora Fiscal Bematech...' + sLineBreak +
                Format('Codigo: %s',[AItem.Codigo]) + sLineBreak +
                Format('Descricao: %s',[AItem.Descricao])  + sLineBreak +
                Format('Valor: %s',[AItem.ValorAsString])
               );
end;

{ TImpressoraECFBematechFactory }

function TImpressoraECFBematechFactory.CreateImpressoraECF: TImpressoraECF;
begin
  Result := TImpressoraECFBematech.Create;
end;

function TImpressoraECFBematechFactory.GetDescription: String;
begin
  Result := 'Bematech MP-20 Modelos I e II'
end;

initialization
    RegisteredPackages.AddObject(PackageName,Pointer(TImpressoraECFBematechFactory));
finalization
    with RegisteredPackages do
      if IndexOf(PackageName) <> -1 then
        Delete(IndexOf(PackageName));
end.
