unit UImpressoraECFDaruma;

interface

uses
  UItem, UImpressoraECF, SysUtils, UPackage;

const
  PackageName = 'ImpressoraECFDaruma.bpl';


Type
  TImpressoraECFDaruma = class(TImpressoraECF)
  public
   procedure IniciarVenda; override;
   procedure VenderItem(const AItem: TItem); override;
   procedure FinalizarVenda(const FormaPagto: TFormaPagtos); override;
  end;

  TImpressoraECFDarumaFactory = class(TImpressoraECFFactory)
  public
   function GetDescription: String; override;
   function CreateImpressoraECF: TImpressoraECF; override;
  end;


implementation

uses Classes;

{ TImpressoraECFDaruma }

procedure TImpressoraECFDaruma.FinalizarVenda(const FormaPagto: TFormaPagtos);
begin
  AddLogOutput(Format('Efetuando forma de pagamento %s na impressora Fiscal Daruma...',[FormaPagtoValues[FormaPagto]]) + SLineBreak +
  'Finalizando venda na impressora fiscal Daruma...');
end;

procedure TImpressoraECFDaruma.IniciarVenda;
begin
  AddLogOutput('Abrindo Cupom na impressora Fiscal Daruma...');
end;

procedure TImpressoraECFDaruma.VenderItem(const AItem: TItem);
begin
  AddLogOutput('Vendendo item na impressora Fiscal Daruma...' + sLineBreak +
                Format('Codigo: %s',[AItem.Codigo]) + sLineBreak +
                Format('Descricao: %s',[AItem.Descricao])  + sLineBreak +
                Format('Valor: %s',[AItem.ValorAsString])
               );
end;

{ TImpressoraECFDarumaFactory }

function TImpressoraECFDarumaFactory.CreateImpressoraECF: TImpressoraECF;
begin
  Result := TImpressoraECFDaruma.Create;
end;

function TImpressoraECFDarumaFactory.GetDescription: String;
begin
  Result := 'Daruma';
end;

initialization
    RegisteredPackages.AddObject(PackageName,Pointer(TImpressoraECFDarumaFactory));
finalization
    with RegisteredPackages do
      if IndexOf(PackageName) <> -1 then
        Delete(IndexOf(PackageName));
end.
