CREATE DATABASE 'localhost:D:\DELPHI\ACTIVEDELPHI\GEN-ESPEC\GEN_ESPEC.FDB'
   USER 'SYSDBA'
   PASSWORD 'masterkey'
   PAGE_SIZE 4096
   DEFAULT CHARACTER SET WIN1252;

CREATE GENERATOR GEN_PESSOA_ID;

CREATE TABLE CLIENTE (
  COD_PESSOA INTEGER NOT NULL,
  RENDA DECIMAL(9, 2) DEFAULT 0.0 NOT NULL,
  NOME_EMPRESA VARCHAR(50) CHARACTER SET WIN1252 COLLATE WIN1252);

ALTER TABLE CLIENTE ADD CONSTRAINT PK_CLIENTE PRIMARY KEY (COD_PESSOA);

CREATE TABLE FORNECEDOR (
  COD_PESSOA INTEGER NOT NULL,
  SITE VARCHAR(60) CHARACTER SET WIN1252 COLLATE WIN1252,
  NOME_PESSOA_CONTATO VARCHAR(50) CHARACTER SET WIN1252 COLLATE WIN1252);

ALTER TABLE FORNECEDOR ADD CONSTRAINT PK_FORNECEDOR PRIMARY KEY (COD_PESSOA);

CREATE TABLE FUNCIONARIO (
  COD_PESSOA INTEGER NOT NULL,
  CARGO VARCHAR(30) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252,
  DATA_ADMISSAO DATE NOT NULL);

ALTER TABLE FUNCIONARIO ADD CONSTRAINT PK_FUNCIONARIO PRIMARY KEY (COD_PESSOA);

CREATE TABLE PESSOA (
  COD_PESSOA INTEGER NOT NULL,
  NOME VARCHAR(50) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252,
  ENDERECO VARCHAR(60) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252,
  CIDADE VARCHAR(30) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252,
  DATA_CADASTRO DATE DEFAULT CURRENT_DATE NOT NULL);

ALTER TABLE PESSOA ADD CONSTRAINT PK_PESSOA PRIMARY KEY (COD_PESSOA);

CREATE TABLE PESSOA_FISICA (
  COD_PESSOA INTEGER DEFAULT 0 NOT NULL,
  CPF VARCHAR(11) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252,
  SEXO CHAR(1) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252,
  DATA_NASCIMENTO DATE NOT NULL);

ALTER TABLE PESSOA_FISICA ADD CONSTRAINT PK_PESSOA_FISICA PRIMARY KEY (COD_PESSOA);
ALTER TABLE PESSOA_FISICA ADD CONSTRAINT UC_PESSOA_FISICA_CPF UNIQUE (CPF);


CREATE TABLE PESSOA_JURIDICA (
  COD_PESSOA INTEGER NOT NULL,
  CNPJ VARCHAR(14) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252,
  RAZAO_SOCIAL VARCHAR(50) CHARACTER SET WIN1252 DEFAULT '' NOT NULL COLLATE WIN1252);

ALTER TABLE PESSOA_JURIDICA ADD CONSTRAINT PK_PESSOA_JURIDICA PRIMARY KEY (COD_PESSOA);
ALTER TABLE PESSOA_JURIDICA ADD CONSTRAINT UC_PESSOA_JURIDICA_CNPJ UNIQUE (CNPJ);

ALTER TABLE PESSOA_FISICA ADD CHECK (SEXO IN ('M','F'));

ALTER TABLE CLIENTE ADD CONSTRAINT FK_CLIENTE_PESSOA
  FOREIGN KEY (COD_PESSOA) REFERENCES PESSOA(COD_PESSOA) ON DELETE CASCADE;
ALTER TABLE FORNECEDOR ADD CONSTRAINT FK_FORNECEDOR_PESSOA_JURIDICA
  FOREIGN KEY (COD_PESSOA) REFERENCES PESSOA_JURIDICA(COD_PESSOA) ON DELETE CASCADE;
ALTER TABLE FUNCIONARIO ADD CONSTRAINT FK_FUNCIONARIO_PESSOA_FISICA
  FOREIGN KEY (COD_PESSOA) REFERENCES PESSOA_FISICA(COD_PESSOA) ON DELETE CASCADE;
ALTER TABLE PESSOA_FISICA ADD CONSTRAINT FK_PESSOA_FISICA_PESSOA
  FOREIGN KEY (COD_PESSOA) REFERENCES PESSOA(COD_PESSOA) ON DELETE CASCADE;
ALTER TABLE PESSOA_JURIDICA ADD CONSTRAINT FK_PESSOA_JURIDICA_PESSOA
  FOREIGN KEY (COD_PESSOA) REFERENCES PESSOA(COD_PESSOA) ON DELETE CASCADE;

SET TERM ^ ;

CREATE TRIGGER BI_PESSOA_COD_PESSOA FOR PESSOA
ACTIVE BEFORE INSERT
POSITION 0
AS
BEGIN
  /* Como no Delphi os campos PK so definidos por padro como Required,
  obrigando que tenham um valor, atribumos, pela aplicao, valor
  zero ou menor ao campo, e o trigger troca esse valor pelo
  do Generator. Triggers e Generators foram tratados em uma 
  srie de artigos meus que iniciou na edio 27 da revista */
  IF ((NEW.COD_PESSOA IS NULL) or (NEW.COD_PESSOA <= 0)) THEN
      NEW.COD_PESSOA = GEN_ID(GEN_PESSOA_ID, 1);
END^

SET TERM ; ^
