unit UCadastro;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  db, Dialogs, StdCtrls, Buttons, DBCtrls,
  DBClient, Grids, DBGrids, ExtCtrls;

type
  TFrmCadastro = class(TForm)
    btnCancelar: TBitBtn;
    btnFechar: TBitBtn;
    btnNovo: TBitBtn;
    btnDeletar: TBitBtn;
    btnSalvar: TBitBtn;
    DBNavigator1: TDBNavigator;
    btnLocalizar: TBitBtn;
    btnImprimir: TBitBtn;
    DataSource1: TDataSource;
    procedure FormCreate(Sender: TObject);
    procedure DataSource1StateChange(Sender: TObject);
    procedure btnDeletarClick(Sender: TObject);
    procedure btnCancelarClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnNovoClick(Sender: TObject);
    procedure btnFecharClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmCadastro: TFrmCadastro;

implementation

uses UDMClient;


{$R *.dfm}

procedure TFrmCadastro.FormCreate(Sender: TObject);
begin
  DataSource1.DataSet.Open;
end;

procedure TFrmCadastro.DataSource1StateChange(Sender: TObject);
begin
    if (DataSource1.DataSet <> nil) and (DataSource1.State <> dsInactive) then
    begin
      btnLocalizar.Enabled := Assigned(btnLocalizar.OnClick);
      btnImprimir.Enabled := Assigned(btnImprimir.OnClick);
      btnNovo.Enabled := (DataSource1.State = dsBrowse);
      btnSalvar.Enabled := DataSource1.State in [dsEdit, dsInsert];
      btnCancelar.Enabled := btnSalvar.Enabled;
      btnDeletar.Enabled := (DataSource1.State = dsBrowse) and (DataSource1.DataSet.RecordCount > 0);
      DBNavigator1.Enabled := (DataSource1.State = dsBrowse) and (DataSource1.DataSet.RecordCount > 1);
    end;
end;

procedure TFrmCadastro.btnDeletarClick(Sender: TObject);
begin
  if Application.MessageBox(
  'Tem certeza que deseja excluir o registro?',
  'Confirmao', MB_ICONQUESTION or MB_YESNO or MB_DEFBUTTON2) = mrYes then
  begin
    DataSource1.DataSet.Delete;
    if DataSource1.DataSet is TClientDataSet then
       TClientDataSet(DataSource1.DataSet).ApplyUpdates(0);
    DataSource1.OnStateChange(DataSource1);
  end;
end;

procedure TFrmCadastro.btnCancelarClick(Sender: TObject);
begin
  DataSource1.DataSet.cancel;
  if DataSource1.DataSet is TClientDataSet then
     {cancelas as atualizaes que no foram aplicadas ainda,
     removendo elas da propriedade Delta do ClientDataSet
     (que armazena as atualizaes a serem efetivadas) }
     TClientDataSet(DataSource1.DataSet).CancelUpdates;
end;

procedure TFrmCadastro.btnSalvarClick(Sender: TObject);
var novo: boolean;
begin
  dmClient.RequiredFieldsValidate(DataSource1.DataSet);
  //verifica se o registro  novo
  novo:= (DataSource1.State = dsInsert);
  DataSource1.DataSet.post;
  {verifica se o DataSource1 est ligado a um ClientDataSet}
  if DataSource1.DataSet is TClientDataSet then
  begin
     {acessa a funo ApplyUpdates do ClientDataSet para aplicar
     as alteraes no banco de dados, passando zero como parmetro,
     para indicar que, se existir mais de uma atualizao para
     ser efetivada no banco de dados, se alguma der erro,]
     no confirma nenhuma. }
     {ApplyUpdates  uma funo, ela retorna o nmero
     de erros ocorridos nas operaes de atualizao.
     Se ela retornar zero  porque no houve nenhum erro
     e o(s) registros(s) foi(foram) atualizado(s) com sucesso.}
     if (TClientDataSet(DataSource1.DataSet).ApplyUpdates(0) = 0)
     and novo then
     begin
         DataSource1.DataSet.Refresh;
         if DataSource1.DataSet.RecordCount > 1 then
           {manda a tabela para o ltimo registro, caso
           o registro seja um registro novo e a tabela possuir mais
           de um registro. Isto  necessrio pois o
           Refresh faz com que a tabela volte para o primeiro
           registro. Se o registro  novo, como a tabela
           est ordenada pela chave primria, por padro,
           ento, o registro que acabou de ser inserido
           ser o ltimo.}
           DataSource1.DataSet.Last;
     end;
  end;
end;

procedure TFrmCadastro.btnNovoClick(Sender: TObject);
begin
  DataSource1.DataSet.Append;
end;

procedure TFrmCadastro.btnFecharClick(Sender: TObject);
begin
  close;
end;

procedure TFrmCadastro.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  DataSource1.DataSet.Close;
end;

end.
