unit UDMClient;

interface

uses
  SysUtils, Classes, DB, DBClient;

type
  TdmClient = class(TDataModule)
    cdsPessoaFuncionario: TClientDataSet;
    cdsPessoaFuncionarioCOD_PESSOA: TIntegerField;
    cdsPessoaFuncionarioNOME: TStringField;
    cdsPessoaFuncionarioENDERECO: TStringField;
    cdsPessoaFuncionarioCIDADE: TStringField;
    cdsPessoaFuncionarioDATA_CADASTRO: TDateField;
    cdsPessoaFisicaFuncionario: TClientDataSet;
    cdsPessoaFornecedor: TClientDataSet;
    cdsPessoaFornecedorCOD_PESSOA: TIntegerField;
    cdsPessoaFornecedorNOME: TStringField;
    cdsPessoaFornecedorENDERECO: TStringField;
    cdsPessoaFornecedorCIDADE: TStringField;
    cdsPessoaFornecedorDATA_CADASTRO: TDateField;
    cdsPessoaCliente: TClientDataSet;
    cdsPessoaClienteCOD_PESSOA: TIntegerField;
    cdsPessoaClienteNOME: TStringField;
    cdsPessoaClienteENDERECO: TStringField;
    cdsPessoaClienteCIDADE: TStringField;
    cdsPessoaClienteDATA_CADASTRO: TDateField;
    cdsFuncionario: TClientDataSet;
    cdsFornecedor: TClientDataSet;
    cdsCliente: TClientDataSet;
    cdsPessoaJuridicaFornecedor: TClientDataSet;
    cdsPessoaFisicaCliente: TClientDataSet;
    cdsPessoaJuridicaCliente: TClientDataSet;
    cdsPessoaClientedtsCliente: TDataSetField;
    cdsPessoaClientedtsPessoaJuridicaCliente: TDataSetField;
    cdsPessoaClientedtsPessoaFisicaCliente: TDataSetField;
    cdsPessoaFornecedordtsPessoaJuridicaFornecedor: TDataSetField;
    cdsPessoaFisicaFuncionarioCOD_PESSOA: TIntegerField;
    cdsPessoaFisicaFuncionarioCPF: TStringField;
    cdsPessoaFisicaFuncionarioSEXO: TStringField;
    cdsPessoaFisicaFuncionarioDATA_NASCIMENTO: TDateField;
    cdsFuncionarioCOD_PESSOA: TIntegerField;
    cdsFuncionarioCARGO: TStringField;
    cdsFuncionarioDATA_ADMISSAO: TDateField;
    cdsPessoaJuridicaFornecedorCOD_PESSOA: TIntegerField;
    cdsPessoaJuridicaFornecedorCNPJ: TStringField;
    cdsPessoaJuridicaFornecedorRAZAO_SOCIAL: TStringField;
    cdsFornecedorCOD_PESSOA: TIntegerField;
    cdsFornecedorSITE: TStringField;
    cdsFornecedorNOME_PESSOA_CONTATO: TStringField;
    cdsClienteCOD_PESSOA: TIntegerField;
    cdsClienteRENDA: TBCDField;
    cdsClienteNOME_EMPRESA: TStringField;
    cdsPessoaFisicaClienteCOD_PESSOA: TIntegerField;
    cdsPessoaFisicaClienteCPF: TStringField;
    cdsPessoaFisicaClienteSEXO: TStringField;
    cdsPessoaFisicaClienteDATA_NASCIMENTO: TDateField;
    cdsPessoaJuridicaClienteCOD_PESSOA: TIntegerField;
    cdsPessoaJuridicaClienteCNPJ: TStringField;
    cdsPessoaJuridicaClienteRAZAO_SOCIAL: TStringField;
    cdsPessoaFuncionariodtsPessoaFisicaFuncionario: TDataSetField;
    cdsPessoaFisicaFuncionariodtsFuncionario: TDataSetField;
    cdsPessoaJuridicaFornecedordtsFornecedor: TDataSetField;
    procedure cdsPessoaFuncionarioAfterInsert(DataSet: TDataSet);
    procedure DataModuleCreate(Sender: TObject);
    procedure cdsPessoaFuncionarioReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
  private
    { Private declarations }
  public
    { Public declarations }
    function RequiredFieldsValidate(DataSet: TDataSet): Boolean;
  end;

var
  dmClient: TdmClient;

implementation

uses UDMServer;

{$R *.dfm}

procedure TdmClient.cdsPessoaFuncionarioAfterInsert(DataSet: TDataSet);
begin
  DataSet['COD_PESSOA']:= dmServer.PrimaryKeyValue('PESSOA');
  TClientDataSet(DataSet).Params[0].AsInteger := DataSet['COD_PESSOA'];
  dmServer.DataSetFieldsInsert(DataSet);
end;

procedure TdmClient.cdsPessoaFuncionarioReconcileError(
  DataSet: TCustomClientDataSet; E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  Action:= raAbort; //aborta a atualizao de dados
  raise Exception.Create(e.message); //mostra a mensagem de erro
end;

procedure TdmClient.DataModuleCreate(Sender: TObject);
begin
  dmServer.SetRequiredFields(cdsPessoaFuncionario);
  dmServer.SetRequiredFields(cdsPessoaFisicaFuncionario);
  dmServer.SetRequiredFields(cdsFuncionario);

  dmServer.SetRequiredFields(cdsPessoaFornecedor);
  dmServer.SetRequiredFields(cdsPessoaJuridicaFornecedor);
  dmServer.SetRequiredFields(cdsFornecedor);

  dmServer.SetRequiredFields(cdsPessoaCliente);
  dmServer.SetRequiredFields(cdsPessoaFisicaCliente);
  dmServer.SetRequiredFields(cdsPessoaJuridicaCliente);
  dmServer.SetRequiredFields(cdsCliente);
end;

function TdmClient.RequiredFieldsValidate(DataSet: TDataSet): Boolean;
var
  I: Integer;
  DetailDataSet: TDataSet;
begin
  result:= true;
  for I := 0 to DataSet.FieldCount - 1 do
  begin
    if (DataSet.Fields[i].Tag = 1)
    and (trim(DataSet.Fields[i].Text) = '') then
    begin
       result:= false;
       DataSet.Fields[i].FocusControl;
       raise Exception.Create(
         'O campo ' + DataSet.Fields[i].DisplayLabel + ' deve ser preenchido.');
    end;

    {Se o campo for um DataSetField, que representa uma outra
    tabela inteira, ento pega a tabela a qual ele est vinculado
    e chama a funo RequiredFieldsValidate recursivamente
    para validar os dados da tabela detalhe. Se na tabela
    detalhe existir outro DataSetField, os campos
    da tabela a qual ele est vinculado tambm sero
    verificados recursivamente e assim por diante,
    s precisando chamar a funo para a tabela mestre,
    no caso desta aplicao, para a tabela pessoa}
    if DataSet.Fields[i] is TDataSetField then
    begin
      DetailDataSet := TDataSetField(DataSet.Fields[i]).NestedDataSet;
      RequiredFieldsValidate(DetailDataSet);
    end;
  end;
end;


end.
