unit UDMServer;

interface

uses
  SysUtils, Classes, DBXpress, WideStrings, DB, SqlExpr, FMTBcd, Provider,
  DBClient, TConnect;

type
  TdmServer = class(TDataModule)
    SQLConnection1: TSQLConnection;
    dtsPessoaFuncionario: TSQLDataSet;
    dtsPessoaFuncionarioCOD_PESSOA: TIntegerField;
    dtsPessoaFuncionarioNOME: TStringField;
    dtsPessoaFuncionarioENDERECO: TStringField;
    dtsPessoaFuncionarioCIDADE: TStringField;
    dtsPessoaFuncionarioDATA_CADASTRO: TDateField;
    dtsPessoaFisicaFuncionario: TSQLDataSet;
    dtsPessoaFisicaFuncionarioCOD_PESSOA: TIntegerField;
    dtsPessoaFisicaFuncionarioCPF: TStringField;
    dtsPessoaFisicaFuncionarioSEXO: TStringField;
    dtsPessoaFisicaFuncionarioDATA_NASCIMENTO: TDateField;
    dtsFuncionario: TSQLDataSet;
    dtsPessoaFornecedor: TSQLDataSet;
    dtsPessoaJuridicaFornecedor: TSQLDataSet;
    dtsFornecedor: TSQLDataSet;
    dtsPessoaCliente: TSQLDataSet;
    dtsPessoaFisicaCliente: TSQLDataSet;
    dtsPessoaJuridicaCliente: TSQLDataSet;
    dtsCliente: TSQLDataSet;
    dspPessoaFuncionario: TDataSetProvider;
    dspPessoaFornecedor: TDataSetProvider;
    dspPessoaCliente: TDataSetProvider;
    dtsPessoaFornecedorCOD_PESSOA: TIntegerField;
    dtsPessoaFornecedorNOME: TStringField;
    dtsPessoaFornecedorENDERECO: TStringField;
    dtsPessoaFornecedorCIDADE: TStringField;
    dtsPessoaFornecedorDATA_CADASTRO: TDateField;
    dtsFuncionarioCOD_PESSOA: TIntegerField;
    dtsFuncionarioCARGO: TStringField;
    dtsFuncionarioDATA_ADMISSAO: TDateField;
    dtsClienteCOD_PESSOA: TIntegerField;
    dtsClienteRENDA: TBCDField;
    dtsClienteNOME_EMPRESA: TStringField;
    dtsPessoaClienteCOD_PESSOA: TIntegerField;
    dtsPessoaClienteNOME: TStringField;
    dtsPessoaClienteENDERECO: TStringField;
    dtsPessoaClienteCIDADE: TStringField;
    dtsPessoaClienteDATA_CADASTRO: TDateField;
    dtsPessoaFisicaClienteCOD_PESSOA: TIntegerField;
    dtsPessoaFisicaClienteCPF: TStringField;
    dtsPessoaFisicaClienteSEXO: TStringField;
    dtsPessoaFisicaClienteDATA_NASCIMENTO: TDateField;
    dtsPessoaJuridicaClienteCOD_PESSOA: TIntegerField;
    dtsPessoaJuridicaClienteCNPJ: TStringField;
    dtsPessoaJuridicaClienteRAZAO_SOCIAL: TStringField;
    LocalConnection1: TLocalConnection;
    dsPessoaFuncionario: TDataSource;
    dsPessoaFornecedor: TDataSource;
    dsPessoaCliente: TDataSource;
    dtsFornecedorCOD_PESSOA: TIntegerField;
    dtsFornecedorSITE: TStringField;
    dtsFornecedorNOME_PESSOA_CONTATO: TStringField;
    dtsPessoaJuridicaFornecedorCOD_PESSOA: TIntegerField;
    dtsPessoaJuridicaFornecedorCNPJ: TStringField;
    dtsPessoaJuridicaFornecedorRAZAO_SOCIAL: TStringField;
    dsPessoaFisicaFuncionario: TDataSource;
    dsPessoaJuridicaFornecedor: TDataSource;
  private
    { Private declarations }
  public
    { Public declarations }
    function PrimaryKeyValue(TableName: ShortString; Incremento: Byte=1): Integer;
    procedure SetRequiredFields(DataSet: TDataSet);
    //retorna o CodPessoa localizada ou -1 se no encontrar
    function LocalizarPessoa(cdsPessoa: TClientDataSet; CPF_CNPJ: String): Integer;
    procedure DataSetFieldsInsert(MasterDataSet: TDataSet);
  end;

var
  dmServer: TdmServer;

implementation

{$R *.dfm}

{ TdmServer }


procedure TdmServer.SetRequiredFields(DataSet: TDataSet);
var i: integer;
begin
  for i := 0 to DataSet.FieldCount - 1 do
  begin
    if DataSet.Fields[i].Required then
    begin
       DataSet.Fields[i].Required:= False;
       DataSet.Fields[i].Tag:= 1;
    end;
  end;
end;

{Percorre todas as tabelas relacionadas ao MasterDataSet,
atravs dos campos DataSetField e faz um insert
em cada um, chamando a funo recursivamente
para pegar os relacionamentos das tabelas
relacionadas. Como por exemplo, a pessoa fsica se
relaciona com a pessoa, e o funcionrio
se relaciona com a pessoa fsica. Chamando
a funo passando o cdsPessoaFuncionario,
ela vai descobrir o relacionamento com o
cdsPessoaFisicaFuncionario. Depois a funo
 chamada recursivamente, passando o cdsPessoaFisicaFuncionario
como parmetro, e descobrindo que nele existe o cdsFuncionario
relacionado.}
procedure TdmServer.DataSetFieldsInsert(MasterDataSet: TDataSet);
var
  i: Integer;
  DefailtDataSet: TDataSet;
begin
  for i := 0 to MasterDataSet.FieldCount - 1 do
  begin
    if MasterDataSet.Fields[i] is TDataSetField then
    begin
       DefailtDataSet := TDataSetField(MasterDataSet.Fields[i]).NestedDataSet;
       DefailtDataSet.Insert;
       DataSetFieldsInsert(DefailtDataSet);
    end;
  end;
end;

function TdmServer.LocalizarPessoa(cdsPessoa: TClientDataSet; CPF_CNPJ: String): Integer;
var qry: TSQLQuery;
begin
  result:= -1;
  qry:= TSQLQuery.Create(nil);
  try
    qry.SQLConnection := SQLConnection1;
    qry.SQL.Text :=
      'select P.COD_PESSOA from PESSOA P ';
    if length(CPF_CNPJ) = 14 then
       qry.SQL.Add(' inner join PESSOA_JURIDICA PJ ' +
         ' ON P.COD_PESSOA = PJ.COD_PESSOA ' +
         ' where PJ.CNPJ = :CPF_CNPJ')
    else
       qry.SQL.Add(' inner join PESSOA_FISICA PF ' +
         ' ON P.COD_PESSOA = PF.COD_PESSOA ' +
         ' where PF.CPF = :CPF_CNPJ');
    qry.Params[0].Text := CPF_CNPJ;
    qry.open;
    {Se encontrou o CPF/CNPJ e o registro no  o mesmo que o
    registro atual no cdsPessoa passado por parmetro, ento o usurio
    digitou o CPF/CNPJ de um registro j cadastrado no banco.}
    if (qry.Fields[0].AsInteger > 0)
    and (qry.Fields[0].AsInteger <> cdsPessoa.FieldByName('COD_PESSOA').AsInteger) then
    begin
       result:= qry.Fields[0].AsInteger;
       cdsPessoa.Close;
       cdsPessoa.Params[0].AsInteger := result;
       cdsPessoa.Open;
    end;
  finally
    qry.Close;
    qry.Free;
  end;
end;

{O parmetro TableName indica o nome da tabela da qual deseja-se
pegar o valor do generator que est associado a ela, sendo
que os generators criados no banco devem seguir o padro
GEN_NomeTable_ID. Caso os generators do seu banco
no estejam neste padro, altere o cdigo desta funo
para o formato do nome do seu generator. O nome do generator
poderia ser passado via parmetro, ao invs de o nome
da tabela, porm, fica mais fcil simplesmente passar
o nome da tabela e a funo montrar o nome do generator
a partir da. Assim, o desenvolvedor no precisa
ficar pensando em como  o formato do nome
dos generators.

O parmetro Incremento  um parmetro Default. Se ele
for omitido na chamada da funo, seu valor ser 1.
Este valor indica que, antes de retornar o valor do generator,
este  incrementado com o valor do parmetro Incremento, e  retornado
o valor do generator depois de incrementado. Se Incremento for passado
como zero, a funo apenas devolve o valor atual do generator, sem
incremet-lo.}
function TDMServer.PrimaryKeyValue(TableName: ShortString; Incremento: Byte=1): Integer;
var dts: TSQLDataSet;
begin
  //Cria um objeto local da classe TSQLDataSet
  dts:= TSQLDataSet.Create(nil);
  try
    //Associa o dts  conexo SQLConnection1
    dts.SQLConnection := SQLConnection1;
    {gera um select para pegar o valor do generator
    associado  tabela informado em TableName.
    A tabela rdb$database  uma tabela de sistema, ou seja,
    uma tabela interna do Firebird. Ela est sendo utilizada aqui
    para executar selects que no trazem dados de nenhuma
    tabela criada pelo desenvolvedor, e sim para executar
    a funo gen_id do Firebird. Como no Firebird, e em muitos outros bancos,
    todo select deve possuir um "from NOME_TABELA"
    (diferente do Microsoft SQL Server), ento  usada
    esta tabela interna do Firebird que sempre retorna apenas um registro
    e permite a execu de funo como gen_id, current_date, current_time, etc.}
    dts.CommandText :=
      'select gen_id(GEN_' +
      TableName + '_ID, '+IntToStr(Incremento)+') from rdb$database';
    dts.Open;
    //Pega o valor do generator 
    result:= dts.Fields[0].AsInteger;
    dts.Close;
  finally
    dts.Free;
  end;
end;    

end.
