
unit cadmedico;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  System.Configuration, FirebirdSql.Data.Firebird, System.Globalization;

type
  TFrmCadMedico = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnSalvar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    txtNome: System.Web.UI.WebControls.TextBox;
    txtCRM: System.Web.UI.WebControls.TextBox;
    dropSexo: System.Web.UI.WebControls.DropDownList;
    dropEspecialidade: System.Web.UI.WebControls.DropDownList;
    btnSalvar: System.Web.UI.WebControls.Button;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    FbDataAdapter1: FirebirdSql.Data.Firebird.FbDataAdapter;
    FbCommand1: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand2: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand3: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand4: FirebirdSql.Data.Firebird.FbCommand;
    cmdEspecialidade: FirebirdSql.Data.Firebird.FbCommand;
    dsMedico: System.Data.DataSet;
    Table: System.Data.DataTable;
    COD_MEDICO: System.Data.DataColumn;
    NOME: System.Data.DataColumn;
    COD_ESPECIALIDADE: System.Data.DataColumn;
    CRM: System.Data.DataColumn;
    SEXO: System.Data.DataColumn;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmCadMedico.InitializeComponent;
type
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Self.FbDataAdapter1 := FirebirdSql.Data.Firebird.FbDataAdapter.Create;
  Self.FbCommand4 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand2 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand1 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand3 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.cmdEspecialidade := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.dsMedico := System.Data.DataSet.Create;
  Self.Table := System.Data.DataTable.Create;
  Self.COD_MEDICO := System.Data.DataColumn.Create;
  Self.NOME := System.Data.DataColumn.Create;
  Self.COD_ESPECIALIDADE := System.Data.DataColumn.Create;
  Self.CRM := System.Data.DataColumn.Create;
  Self.SEXO := System.Data.DataColumn.Create;
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).BeginInit;
  Include(Self.btnSalvar.Click, Self.btnSalvar_Click);
  // 
  // conn
  // 
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  // 
  // FbDataAdapter1
  // 
  Self.FbDataAdapter1.DeleteCommand := Self.FbCommand4;
  Self.FbDataAdapter1.InsertCommand := Self.FbCommand2;
  Self.FbDataAdapter1.SelectCommand := Self.FbCommand1;
  Self.FbDataAdapter1.UpdateCommand := Self.FbCommand3;
  // 
  // FbCommand4
  // 
  Self.FbCommand4.CommandText := 'DELETE FROM MEDICO WHERE COD_MEDICO = @p1';
  Self.FbCommand4.Connection := Self.conn;
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_MEDICO', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p2', FirebirdSql.Data.Firebird.FbDbType.VarChar, 50, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'NOME', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p3', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_ESPECIALIDADE', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p4', FirebirdSql.Data.Firebird.FbDbType.VarChar, 10, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'CRM', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p5', FirebirdSql.Data.Firebird.FbDbType.VarChar, 1, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'SEXO', System.Data.DataRowVersion.Original, 
        nil));
  // 
  // FbCommand2
  // 
  Self.FbCommand2.CommandText := 'INSERT INTO MEDICO (COD_MEDICO,NOME,COD_ES' +
  'PECIALIDADE,CRM,SEXO) VALUES (@p1,@p2,@p3,@p4,@p5)';
  Self.FbCommand2.Connection := Self.conn;
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_MEDICO'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p2', FirebirdSql.Data.Firebird.FbDbType.VarChar, 50, 'NOME'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p3', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_ESPECIALIDAD' +
      'E'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p4', FirebirdSql.Data.Firebird.FbDbType.VarChar, 10, 'CRM'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p5', FirebirdSql.Data.Firebird.FbDbType.VarChar, 1, 'SEXO'));
  // 
  // FbCommand1
  // 
  Self.FbCommand1.CommandText := 'select * from MEDICO where COD_MEDICO = @C' +
  'OD_MEDICO';
  Self.FbCommand1.Connection := Self.conn;
  Self.FbCommand1.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'COD_MEDICO', FirebirdSql.Data.Firebird.FbDbType.Integer));
  // 
  // FbCommand3
  // 
  Self.FbCommand3.CommandText := 'UPDATE MEDICO SET COD_MEDICO = @p1,NOME = ' +
  '@p2,COD_ESPECIALIDADE = @p3,CRM = @p4,SEXO = @p5 WHERE COD_MEDICO = @p6';
  Self.FbCommand3.Connection := Self.conn;
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_MEDICO'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p2', FirebirdSql.Data.Firebird.FbDbType.VarChar, 50, 'NOME'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p3', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_ESPECIALIDAD' +
      'E'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p4', FirebirdSql.Data.Firebird.FbDbType.VarChar, 10, 'CRM'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p5', FirebirdSql.Data.Firebird.FbDbType.VarChar, 1, 'SEXO'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p6', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_MEDICO', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p7', FirebirdSql.Data.Firebird.FbDbType.VarChar, 50, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'NOME', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p8', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_ESPECIALIDADE', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p9', FirebirdSql.Data.Firebird.FbDbType.VarChar, 10, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'CRM', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p10', FirebirdSql.Data.Firebird.FbDbType.VarChar, 1, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'SEXO', System.Data.DataRowVersion.Original, 
        nil));
  // 
  // cmdEspecialidade
  // 
  Self.cmdEspecialidade.CommandText := 'SELECT COD_ESPECIALIDADE, DESCRICAO ' +
  'FROM ESPECIALIDADE'#13#10'ORDER BY DESCRICAO';
  Self.cmdEspecialidade.Connection := Self.conn;
  // 
  // dsMedico
  // 
  Self.dsMedico.DataSetName := 'dsMedico';
  Self.dsMedico.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.dsMedico.Namespace := 'http://www.tempuri.org/dsMedico.xsd';
  Self.dsMedico.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.Table));
  // 
  // Table
  // 
  Self.Table.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO, 
          Self.NOME, Self.COD_ESPECIALIDADE, Self.CRM, Self.SEXO));
  Self.Table.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('COD_MEDICO'), True)));
  Self.Table.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO);
  Self.Table.TableName := 'Table';
  // 
  // COD_MEDICO
  // 
  Self.COD_MEDICO.AllowDBNull := False;
  Self.COD_MEDICO.ColumnName := 'COD_MEDICO';
  Self.COD_MEDICO.DataType := TypeOf(Integer);
  Self.COD_MEDICO.DefaultValue := System.Object(0);
  // 
  // NOME
  // 
  Self.NOME.AllowDBNull := False;
  Self.NOME.ColumnName := 'NOME';
  Self.NOME.MaxLength := 50;
  // 
  // COD_ESPECIALIDADE
  // 
  Self.COD_ESPECIALIDADE.AllowDBNull := False;
  Self.COD_ESPECIALIDADE.ColumnName := 'COD_ESPECIALIDADE';
  Self.COD_ESPECIALIDADE.DataType := TypeOf(Integer);
  // 
  // CRM
  // 
  Self.CRM.AllowDBNull := False;
  Self.CRM.ColumnName := 'CRM';
  Self.CRM.MaxLength := 10;
  // 
  // SEXO
  // 
  Self.SEXO.AllowDBNull := False;
  Self.SEXO.ColumnName := 'SEXO';
  Self.SEXO.MaxLength := 1;
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).EndInit;
end;
{$ENDREGION}

procedure TFrmCadMedico.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  if not IsPostBack then
  begin
     conn.open;
     try
       dropEspecialidade.DataSource := cmdEspecialidade.ExecuteReader;
       dropEspecialidade.DataBind;
       if Request['cod'] <> nil then
       begin
         FbDataAdapter1.SelectCommand.Parameters[0].Value := Request['cod'];
         FbDataAdapter1.Fill(dsMedico);
         Session['dsMedico']:= dsMedico;
         txtNome.Text:= dsMedico.Tables[0].Rows[0].Item['NOME'].ToString;
         txtCRM.Text:= dsMedico.Tables[0].Rows[0].Item['CRM'].ToString;
         dropSexo.SelectedValue:=
           dsMedico.Tables[0].Rows[0].Item['SEXO'].ToString;
         dropEspecialidade.SelectedValue:=
           dsMedico.Tables[0].Rows[0].Item['COD_ESPECIALIDADE'].ToString;
       end;
     finally
       conn.close;
     end;
  end;
end;

procedure TFrmCadMedico.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TFrmCadMedico.btnSalvar_Click(sender: System.Object; e: System.EventArgs);
var
  row: DataRow;
begin
  if Request['cod'] = nil then
     row:= dsMedico.Tables[0].NewRow
  else
  begin
    dsMedico:= DataSet(Session['dsMedico']);
    row:= dsMedico.Tables[0].Rows[0];
  end;
  row['NOME']:= txtNome.Text;
  row['CRM']:= txtCRM.Text;
  row['SEXO']:= dropSexo.SelectedValue.ToString;
  row['COD_ESPECIALIDADE']:= dropEspecialidade.SelectedValue.ToString;
  if Request['cod'] = nil then
     dsMedico.Tables[0].Rows.Add(row);
  FbDataAdapter1.Update(dsMedico);
  Response.Redirect('medicos.aspx');
end;

end.

