
unit medicos;

interface

uses
  System.Text,
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  FirebirdSql.Data.Firebird, System.Configuration, System.Globalization;

type
  TFrmMedico = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid1_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure dropEspecialidade_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    DataGrid1: System.Web.UI.WebControls.DataGrid;
    Button1: System.Web.UI.WebControls.Button;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    FbDataAdapter1: FirebirdSql.Data.Firebird.FbDataAdapter;
    FbCommand1: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand2: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand3: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand4: FirebirdSql.Data.Firebird.FbCommand;
    dsMedico: System.Data.DataSet;
    Table: System.Data.DataTable;
    COD_MEDICO: System.Data.DataColumn;
    NOME: System.Data.DataColumn;
    ESPECIALIDADE: System.Data.DataColumn;
    cmdEspecialidade: FirebirdSql.Data.Firebird.FbCommand;
    COD_ESPECIALIDADE: System.Data.DataColumn;
    txtNome: System.Web.UI.WebControls.TextBox;
    dropEspecialidade: System.Web.UI.WebControls.DropDownList;
    Button2: System.Web.UI.WebControls.Button;
    procedure OnInit(e: EventArgs); override;
  private
    procedure FiltrarDataGrid;
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmMedico.InitializeComponent;
type
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Self.FbDataAdapter1 := FirebirdSql.Data.Firebird.FbDataAdapter.Create;
  Self.FbCommand4 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand2 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand1 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand3 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.cmdEspecialidade := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.dsMedico := System.Data.DataSet.Create;
  Self.Table := System.Data.DataTable.Create;
  Self.COD_MEDICO := System.Data.DataColumn.Create;
  Self.NOME := System.Data.DataColumn.Create;
  Self.ESPECIALIDADE := System.Data.DataColumn.Create;
  Self.COD_ESPECIALIDADE := System.Data.DataColumn.Create;
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).BeginInit;
  Include(Self.DataGrid1.DeleteCommand, Self.DataGrid1_DeleteCommand);
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // conn
  // 
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  // 
  // FbDataAdapter1
  // 
  Self.FbDataAdapter1.DeleteCommand := Self.FbCommand4;
  Self.FbDataAdapter1.InsertCommand := Self.FbCommand2;
  Self.FbDataAdapter1.SelectCommand := Self.FbCommand1;
  Self.FbDataAdapter1.UpdateCommand := Self.FbCommand3;
  // 
  // FbCommand4
  // 
  Self.FbCommand4.CommandText := 'delete from MEDICO where COD_MEDICO = @COD' +
  '_MEDICO';
  Self.FbCommand4.Connection := Self.conn;
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'COD_MEDICO', FirebirdSql.Data.Firebird.FbDbType.Integer));
  // 
  // FbCommand1
  // 
  Self.FbCommand1.CommandText := 'select M.COD_MEDICO, M.NOME,  E.DESCRICAO ' +
  'AS ESPECIALIDADE,'#13#10'M.COD_ESPECIALIDADE'#13#10'from MEDICO M'#13#10'I' +
  'NNER JOIN ESPECIALIDADE E ON E.COD_ESPECIALIDADE = M.COD_ESPECIALIDADE'#13 +
  #10'order by M.NOME';
  Self.FbCommand1.Connection := Self.conn;
  // 
  // cmdEspecialidade
  // 
  Self.cmdEspecialidade.CommandText := 'select COD_ESPECIALIDADE, DESCRICAO ' +
  'FROM ESPECIALIDADE ORDER BY DESCRICAO';
  Self.cmdEspecialidade.Connection := Self.conn;
  // 
  // dsMedico
  // 
  Self.dsMedico.DataSetName := 'dsMedico';
  Self.dsMedico.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.dsMedico.Namespace := 'http://www.tempuri.org/dsMedico.xsd';
  Self.dsMedico.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.Table));
  // 
  // Table
  // 
  Self.Table.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO, 
          Self.NOME, Self.ESPECIALIDADE, Self.COD_ESPECIALIDADE));
  Self.Table.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('COD_MEDICO'), True)));
  Self.Table.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO);
  Self.Table.TableName := 'Table';
  // 
  // COD_MEDICO
  // 
  Self.COD_MEDICO.AllowDBNull := False;
  Self.COD_MEDICO.ColumnName := 'COD_MEDICO';
  Self.COD_MEDICO.DataType := TypeOf(Integer);
  // 
  // NOME
  // 
  Self.NOME.AllowDBNull := False;
  Self.NOME.ColumnName := 'NOME';
  Self.NOME.MaxLength := 50;
  // 
  // ESPECIALIDADE
  // 
  Self.ESPECIALIDADE.AllowDBNull := False;
  Self.ESPECIALIDADE.ColumnName := 'ESPECIALIDADE';
  Self.ESPECIALIDADE.MaxLength := 50;
  // 
  // COD_ESPECIALIDADE
  // 
  Self.COD_ESPECIALIDADE.AllowDBNull := False;
  Self.COD_ESPECIALIDADE.ColumnName := 'COD_ESPECIALIDADE';
  Self.COD_ESPECIALIDADE.DataType := TypeOf(Integer);
  Include(Self.dropEspecialidade.SelectedIndexChanged, Self.dropEspecialidade_SelectedIndexChanged);
  Include(Self.Button2.Click, Self.Button2_Click);
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).EndInit;
end;
{$ENDREGION}

procedure TFrmMedico.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  {Verifica se a pgina est sendo aberta em uma nova requisio
  ou se apenas est sendo recarregada devido ao disparo de algum
  componente na mesma, como o clique em um boto. Se o endereo da pgina
  for redigitado  criada uma nova requisio e no um post back.
  O postback ocorre depois dos disparos de eventos.}
  if not IsPostBack then
  begin
    {abre a conexo com o banco
    se o Pool estiver habilitado, como explicado no artigo,
    pega uma conexo j estabelecida do pool}
    conn.open;
    try
      {o mtodo Fill do FbDataAdapter preenche um DataSet ou DataTable
      com os dados da tabela para o qual o primeiro foi configurado.
      Os componentes DataSet e DataTable trabalham desconectados do banco,
      como o ClientDataSet.}
      FbDataAdapter1.Fill(dsMedico);
      {Guarda o DataSet com os dados na sesso do usurio
      para permitir manipular estes dados posteriormente, como
      no processo de ordenao ou paginao, sem precisar fazer acesso
      novamente ao banco de dados para pegar os dados novamente, pois,
      como o ASP.NET  Stateless, ou seja, no guarda os dados
      da pgina a cada requisio, os dados so perdidos se no guardados
      em sesso (um conceito fundamental associado ao desenvolvimento
      de sistemas web em qualquer linguagem).}
      Session['dsMedico']:= dsMedico;
      DataGrid1.DataSource := dsMedico;
      //Vincula os dados do DataSet ao DataGrid
      DataGrid1.DataBind;
      dropEspecialidade.DataSource := cmdEspecialidade.ExecuteReader;
      dropEspecialidade.DataBind;
      dropEspecialidade.Items.Insert(0, ListItem.Create('Todas', '0'));
      dropEspecialidade.SelectedIndex:= 0;
    finally
      {fecha a conexo ao banco. Se o pool estiver
      habilitado apenas devolve a conexo ao pool, no fecha
      ela como ocorre em aplicaes desktop.}
      conn.close;
    end;
  end;
end;

procedure TFrmMedico.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TFrmMedico.FiltrarDataGrid;
var sb: StringBuilder;
begin
  sb:= StringBuilder.Create('1=1 ');
  dsMedico := DataSet(Session['dsMedico']);
  if txtNome.Text.Trim <> '' then
    sb.AppendFormat(
      ' and NOME like ''{0}*'' ', [txtNome.Text]);
  if dropEspecialidade.SelectedIndex > 0 then
      sb.AppendFormat(
       ' and COD_ESPECIALIDADE = {0} ', [dropEspecialidade.SelectedValue]);
  dsMedico.Tables[0].DefaultView.RowFilter := sb.ToString;
  DataGrid1.DataSource := dsMedico.Tables[0].DefaultView;
  DataGrid1.DataBind;
end;

procedure TFrmMedico.dropEspecialidade_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
begin
  FiltrarDataGrid;
end;

procedure TFrmMedico.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  FiltrarDataGrid;
end;

procedure TFrmMedico.DataGrid1_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  cod: System.Object;
  row: DataRow;
begin
  dsMedico:= DataSet(Session['dsMedico']);
  cod:=  DataGrid1.DataKeys[e.Item.DataSetIndex];
  conn.open;
  try
    FbDataAdapter1.DeleteCommand.Parameters[0].Value := cod;
    FbDataAdapter1.DeleteCommand.ExecuteNonQuery;
    row:= dsMedico.Tables[0].Rows.Find(cod);
    dsMedico.Tables[0].Rows.Remove(row);
    DataGrid1.DataBind;
  finally
    conn.close;
  end;
end;

procedure TFrmMedico.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  Response.Redirect('cadmedico.aspx');
end;

end.

