unit uFrmMain;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,  Google.GData.Calendar,
  Google.GData.Client, Google.GData.Extensions;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    GroupBox1: System.Windows.Forms.GroupBox;
    Label5: System.Windows.Forms.Label;
    rtbDescricao: System.Windows.Forms.RichTextBox;
    Label4: System.Windows.Forms.Label;
    tbOnde: System.Windows.Forms.TextBox;
    dtDataFim: System.Windows.Forms.DateTimePicker;
    Label3: System.Windows.Forms.Label;
    dtDataInicio: System.Windows.Forms.DateTimePicker;
    tbTitulos: System.Windows.Forms.TextBox;
    btIncluir: System.Windows.Forms.Button;
    Senha: System.Windows.Forms.Label;
    tbSenha: System.Windows.Forms.TextBox;
    tbUsuario: System.Windows.Forms.TextBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btIncluir_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
  Self.tbSenha := System.Windows.Forms.TextBox.Create;
  Self.Senha := System.Windows.Forms.Label.Create;
  Self.tbUsuario := System.Windows.Forms.TextBox.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label5 := System.Windows.Forms.Label.Create;
  Self.rtbDescricao := System.Windows.Forms.RichTextBox.Create;
  Self.Label4 := System.Windows.Forms.Label.Create;
  Self.tbOnde := System.Windows.Forms.TextBox.Create;
  Self.dtDataFim := System.Windows.Forms.DateTimePicker.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.dtDataInicio := System.Windows.Forms.DateTimePicker.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.tbTitulos := System.Windows.Forms.TextBox.Create;
  Self.btIncluir := System.Windows.Forms.Button.Create;
  Self.GroupBox1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // GroupBox1
  // 
  Self.GroupBox1.Controls.Add(Self.tbSenha);
  Self.GroupBox1.Controls.Add(Self.Senha);
  Self.GroupBox1.Controls.Add(Self.tbUsuario);
  Self.GroupBox1.Controls.Add(Self.Label1);
  Self.GroupBox1.Controls.Add(Self.Label5);
  Self.GroupBox1.Controls.Add(Self.rtbDescricao);
  Self.GroupBox1.Controls.Add(Self.Label4);
  Self.GroupBox1.Controls.Add(Self.tbOnde);
  Self.GroupBox1.Controls.Add(Self.dtDataFim);
  Self.GroupBox1.Controls.Add(Self.Label3);
  Self.GroupBox1.Controls.Add(Self.dtDataInicio);
  Self.GroupBox1.Controls.Add(Self.Label2);
  Self.GroupBox1.Controls.Add(Self.tbTitulos);
  Self.GroupBox1.Location := System.Drawing.Point.Create(8, 6);
  Self.GroupBox1.Name := 'GroupBox1';
  Self.GroupBox1.Size := System.Drawing.Size.Create(472, 200);
  Self.GroupBox1.TabIndex := 14;
  Self.GroupBox1.TabStop := False;
  // 
  // tbSenha
  // 
  Self.tbSenha.Location := System.Drawing.Point.Create(256, 168);
  Self.tbSenha.Name := 'tbSenha';
  Self.tbSenha.PasswordChar := '*';
  Self.tbSenha.TabIndex := 19;
  Self.tbSenha.Text := '';
  // 
  // Senha
  // 
  Self.Senha.Location := System.Drawing.Point.Create(208, 173);
  Self.Senha.Name := 'Senha';
  Self.Senha.Size := System.Drawing.Size.Create(100, 16);
  Self.Senha.TabIndex := 20;
  Self.Senha.Text := 'Senha';
  // 
  // tbUsuario
  // 
  Self.tbUsuario.Location := System.Drawing.Point.Create(104, 168);
  Self.tbUsuario.Name := 'tbUsuario';
  Self.tbUsuario.TabIndex := 17;
  Self.tbUsuario.Text := '';
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(8, 168);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(80, 16);
  Self.Label1.TabIndex := 18;
  Self.Label1.Text := 'Usuario';
  // 
  // Label5
  // 
  Self.Label5.Location := System.Drawing.Point.Create(8, 104);
  Self.Label5.Name := 'Label5';
  Self.Label5.Size := System.Drawing.Size.Create(80, 16);
  Self.Label5.TabIndex := 16;
  Self.Label5.Text := 'Descrio';
  // 
  // rtbDescricao
  // 
  Self.rtbDescricao.Location := System.Drawing.Point.Create(104, 100);
  Self.rtbDescricao.Name := 'rtbDescricao';
  Self.rtbDescricao.Size := System.Drawing.Size.Create(352, 60);
  Self.rtbDescricao.TabIndex := 15;
  Self.rtbDescricao.Text := '';
  // 
  // Label4
  // 
  Self.Label4.Location := System.Drawing.Point.Create(8, 74);
  Self.Label4.Name := 'Label4';
  Self.Label4.Size := System.Drawing.Size.Create(96, 16);
  Self.Label4.TabIndex := 14;
  Self.Label4.Text := 'Onde';
  // 
  // tbOnde
  // 
  Self.tbOnde.Location := System.Drawing.Point.Create(104, 72);
  Self.tbOnde.Name := 'tbOnde';
  Self.tbOnde.Size := System.Drawing.Size.Create(352, 20);
  Self.tbOnde.TabIndex := 13;
  Self.tbOnde.Text := '';
  // 
  // dtDataFim
  // 
  Self.dtDataFim.CustomFormat := 'dd/MM/yyyy hh:mm';
  Self.dtDataFim.Format := System.Windows.Forms.DateTimePickerFormat.Custom;
  Self.dtDataFim.Location := System.Drawing.Point.Create(232, 44);
  Self.dtDataFim.Name := 'dtDataFim';
  Self.dtDataFim.Size := System.Drawing.Size.Create(120, 20);
  Self.dtDataFim.TabIndex := 12;
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(8, 48);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(80, 16);
  Self.Label3.TabIndex := 11;
  Self.Label3.Text := 'Quando:';
  // 
  // dtDataInicio
  // 
  Self.dtDataInicio.CustomFormat := 'dd/MM/yyyy hh:mm';
  Self.dtDataInicio.Format := System.Windows.Forms.DateTimePickerFormat.Custom;
  Self.dtDataInicio.Location := System.Drawing.Point.Create(104, 44);
  Self.dtDataInicio.Name := 'dtDataInicio';
  Self.dtDataInicio.Size := System.Drawing.Size.Create(120, 20);
  Self.dtDataInicio.TabIndex := 10;
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(8, 19);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(96, 16);
  Self.Label2.TabIndex := 9;
  Self.Label2.Text := 'Ttulo do Evento:';
  // 
  // tbTitulos
  // 
  Self.tbTitulos.Location := System.Drawing.Point.Create(104, 16);
  Self.tbTitulos.Name := 'tbTitulos';
  Self.tbTitulos.Size := System.Drawing.Size.Create(352, 20);
  Self.tbTitulos.TabIndex := 8;
  Self.tbTitulos.Text := '';
  // 
  // btIncluir
  // 
  Self.btIncluir.Location := System.Drawing.Point.Create(8, 216);
  Self.btIncluir.Name := 'btIncluir';
  Self.btIncluir.Size := System.Drawing.Size.Create(96, 23);
  Self.btIncluir.TabIndex := 13;
  Self.btIncluir.Text := 'Incluir Evento';
  Include(Self.btIncluir.Click, Self.btIncluir_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(488, 246);
  Self.Controls.Add(Self.GroupBox1);
  Self.Controls.Add(Self.btIncluir);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Self.GroupBox1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.btIncluir_Click(sender: System.Object; e: System.EventArgs);
Const
  CalendarioPrimario = 'http://www.google.com/calendar/feeds/default/private/full';
var
  ServicoDeCalendario: CalendarService;
  Evento: EventEntry;
  Local: Where;
  DataHora: When;
  Url: Uri;
begin
  if (tbUsuario.TextLength > 0) and (tbSenha.TextLength > 0) then
  begin
    //Criando um Servio de Calendario
    ServicoDeCalendario := CalendarService.Create('ExemploDeCalendario');
    //Criando Objeto de Entrada
    Evento := EventEntry.Create;
    //Criando Objeto de Local
    Local := Where.Create;
    DataHora := When.Create;
    try
      //Setando as Credenciais do Usuarios
      ServicoDeCalendario.setUserCredentials(tbUsuario.Text,tbSenha.Text);

      Evento.Title.Text := tbTitulos.Text;
      Evento.Content.Content := rtbDescricao.Text;
      Local.ValueString := tbOnde.Text;
      Event
      //Atribuindo local ao evento
      Evento.Locations.Add(Local);

      //Definindo inicio e trmino do evento
      DataHora.StartTime := dtDataInicio.Value;
      DataHora.EndTime := dtDataFim.Value;

      //Atribuindo o horrio ao evento
      Evento.Times.Add(DataHora);

      //URL calendario padro
      Url := Uri.Create(CalendarioPrimario);

      ServicoDeCalendario.Insert(Url,Evento);

      MessageBox.Show('Evento inserido com sucesso.','Ateno');
    finally
      ServicoDeCalendario.Free;
      Evento.Free;
      Local.Free;
      DataHora.Free
    end;
  end else
    MessageBox.Show('Informe usurio e senha.','Ateno');
end;

end.
