unit uThExecQuery;

interface

uses
  Classes,DBXpress,SqlExpr,Provider,DbClient,forms;

type
  TThExecQueryStatus = (thsNovo,thsExecutando,thsConcluido);
  ThExecQuery = class(TThread)
  private
    Conexao   : TSQLConnection;
    Query     : TSQLDataSet;
    thStatus  : TThExecQueryStatus;
    function pegaseq(Texto : String; posicao : Integer;sep : Char = #124) : String;
    function contaseq(Texto : String;sep : Char = #124) : Integer;
  protected
    fErro      : Boolean;
    fMsgErro   : String;
    fPathBanco : String;
    fUser      : String;
    fPasswd    : String;
    fSql       : String;
    fParams    : String;
    fServico   : String;
    fCabecalho : Boolean;
    procedure Processa;
  public
    Dados : TStringList; // Resultado da query
    constructor Create(const PathBanco: String; const User: string;
                const Passwd : String; const Sql :String; const Params : String;Cabecalho : Boolean = True); virtual;
    destructor  Destroy; override;
    procedure   Execute; override;
    function    Erro    : Boolean;
    function    MsgErro : String;
    procedure   setServico(NomeServico :String);
    function    getServico : String;
    function    Status  : TThExecQueryStatus;
  end;

implementation

uses SysUtils, DB;

procedure ThExecQuery.execute;
begin
   Priority := tpLower;
   Processa;
end;

constructor ThExecQuery.Create(const PathBanco, User, Passwd, Sql,
   Params: String;Cabecalho : Boolean = True);
begin
   fPathBanco := PathBanco;
   fUser      := User;
   fPasswd    := Passwd;
   fSql       := Sql;
   fParams    := Params;
   fErro      := False;
   fMsgErro   := '';
   fCabecalho := Cabecalho;
   inherited Create(False);
   thStatus := thsNovo;
end;

destructor ThExecQuery.Destroy;
begin
  Conexao := Nil;
  Query   := Nil;
  FreeAndNil(Dados);
  inherited;
end;

function ThExecQuery.Erro: Boolean;
begin
   Result := fErro;
end;

procedure ThExecQuery.Processa;
Var
   i,qtd                   : Integer;
   Comando,Parametro,Lin   : String;
   Executar                : Boolean;
   Tipopar,NomePar,Valpar  : String;
   Transacao               : TTransactionDesc;
Const Sep = chr(124);
begin
   // Definindo a conexao
   Conexao  := TSQLConnection.Create(nil);
   thStatus := thsExecutando;
   with Conexao do begin
      ConnectionName := 'IBConnection';
      DriverName     := 'Interbase';
      GetDriverFunc  := 'getSQLDriverINTERBASE';
      KeepConnection := False;
      LibraryName    := 'dbexpint.dll';
      LoginPrompt    := False;
      TableScope     := [tsView];
      VendorLib      := 'gds32.dll';
      Params.Add('DriverName=Interbase');
      Params.Add('Database='+fPathBanco);
      Params.Add('RoleName=RoleName');
      Params.Add('User_Name='+fUser);
      Params.Add('Password='+fPasswd);
      Params.Add('ServerCharSet=');
      Params.Add('SQLDialect=3');
      Params.Add('ErrorResourceFile=');
      Params.Add('LocaleCode=0000');
      Params.Add('BlobSize=-1');
      Params.Add('CommitRetain=False');
      Params.Add('WaitOnLocks=True');
      Params.Add('Interbase TransIsolation=ReadCommited');
      Params.Add('Trim Char=True');
      Try
         Open;
      Except
         on e : Exception do begin
            fErro     := True;
            fMsgErro  := e.Message;
         End;
      End;
   End;
   // Definindo a query
   Query := TSQLDataSet.Create(nil);
   try
      with Query do begin
         SQLConnection := Conexao;
         CommandType   := ctQuery;
         Comando       := fSql;
         // Identifica se ser executado com ExecSQL ou Open
         if Copy(UpperCase(Comando),1,6) = 'SELECT' then Executar := False else Executar := True;
         CommandText   := Comando;
         // Passagem de parmetros
         try
             if (fParams <> '') then begin
                qtd := contaseq(fParams);
                for i := 1 to qtd do begin
                   Parametro  := pegaseq(fParams,i);
                   Tipopar    := uppercase(pegaseq(Parametro,1,';'));
                   NomePar    := pegaseq(Parametro,2,';');
                   Valpar     := pegaseq(Parametro,3,';');
                   // Tipos de parmentros: 'D=Date T=DateTime I=Integer F=Float S=String
                   if (Tipopar = 'D') then ParamByName(NomePar).AsDate          := Strtodate(Valpar)
                   else if (Tipopar = 'T') then ParamByName(NomePar).AsDateTime := Strtodatetime(Valpar)
                   else if (Tipopar = 'I') then ParamByName(NomePar).AsInteger  := Strtoint(Valpar)
                   else if (Tipopar = 'F') then ParamByName(NomePar).AsFloat    := StrToFloat(Valpar)
                   else ParamByName(NomePar).AsString := Valpar;
                End;
             End;
             Transacao.TransactionID  := 5;
             Transacao.IsolationLevel := xilREADCOMMITTED;
             Conexao.StartTransaction(Transacao);
             if Executar then begin
                ExecSQL(False);
                Conexao.Commit(Transacao);
             end else begin
                Open;
                Dados := TStringList.Create;
                // Definindo os nomes dos campos
                if fCabecalho then begin
                   For i := 0 to FieldCount -1 do begin
                      if (Lin <> '') then Lin := Lin + Sep;
                      Qtd := Fields[i].Size;
                      if Qtd < Length(Fields[i].FieldName) then Qtd := length(Fields[i].FieldName);
                      if Qtd < 10 then Qtd := 10;
                      Lin := Lin + Fields[i].FieldName + '=' + inttostr(Qtd);
                   End;
                   Dados.Add(Lin);
                End;
                while not Eof do begin
                   Lin := '';
                   For i := 0 to (FieldCount -1) do begin
                      if (Lin <> '') then Lin := Lin + Sep;
                      if Fields[i].IsBlob then Lin := Lin + '(Blob)'
                      else Lin := Lin + Fields[i].AsString;
                   End;
                   Dados.Add(Lin);
                   Next;
                End;
                Conexao.Commit(Transacao);
             End;
             thStatus := thsConcluido;
         except
            on e : Exception do begin
               fErro     := True;
               fMsgErro  := e.Message;
               Conexao.Rollback(Transacao);
               thStatus := thsConcluido;
            End;
         end;
      End;
   Finally
      thStatus := thsConcluido;
      Conexao.Close;
      Query.Free;
      Conexao.Free;
   End;
end;

function ThExecQuery.MsgErro: String;
begin
   Result := fMsgErro;
end;

function ThExecQuery.Status: TThExecQueryStatus;
begin
   Result := thStatus;
end;
procedure ThExecQuery.setServico(NomeServico: String);
begin
   fServico := NomeServico;
end;

function ThExecQuery.getServico: String;
begin
   Result := fServico;
end;

function ThExecQuery.pegaseq(Texto: String; posicao: Integer;
  sep: Char): String;
// Retorna a string n de uma sequencia do tipo: 23,78,58,90 ou 10|25|52|58
// Exemplo: pegaseq(tipo,2) = 78
Var
   conta : Integer;
   tmp   : String;
begin
   Result := '';
   conta  := 1;
   while length(Texto) > 0 do begin
      if pos(sep,Texto) > 0 then begin
         tmp   := copy(Texto,1,pos(sep,Texto)-1);
         Texto := copy(Texto,pos(sep,texto)+1,length(Texto));
      end else begin
         tmp   := texto;
         Texto := '';
      end;
      if conta = posicao then begin
         result := tmp;
         texto  := '';
      end;
      inc(conta);
   end;
end;

function ThExecQuery.contaseq(Texto: String; sep: Char): Integer;
// Retorna a quantidade de dados em uma sequencia do tipo: 23,78,58,90
// Exemplo: contaseq(tipo) = 4
Var
   conta : Integer;
   tmp   : String;
begin
   conta  := 0;
   while length(Texto) > 0 do begin
      if pos(sep,Texto) > 0 then begin
         tmp   := copy(Texto,1,pos(sep,Texto)-1);
         Texto := copy(Texto,pos(sep,texto)+1,length(Texto));
         inc(conta);
      end else begin
         tmp := texto;
         inc(conta);
         texto := '';
      end;
   end;
   Result := conta;
end;

end.
