unit Uprincipal;

interface

uses PSL,ubdagenda;

const
  Form1 = AutoID;

function HandleEvent(var Event: EventType): Boolean;

implementation

const
  FldCodigo = AutoID;
  Fldnome = AutoID;
  fldtelefone = AutoID;
  Label1 = AutoID;
  Label2 = AutoID;
  Label3 = AutoID;
  btvoltar = AutoID;
  btavancar = AutoID;
  btalterar = AutoID;
  btnovo = AutoID;
  btgravar = AutoID;
  btcancelar = AutoID;
  btexcluir = AutoID;
  FldIdAtual = AutoID;
  AlertaconfirmaExclusao = AutoID;

resource
  ALERT AlertaconfirmaExclusao {HELP String1} {DEFAULTBUTTON 0} CONFIRMATION
  BEGIN
    TITLE 'Excluso'
    MESSAGE 'Certeza que deseja excluir?'
    BUTTONS 'Sim' 'No'
  END;

resource
  FORM Form1 AT (0 0 160 160) NOFRAME
  BEGIN
    TITLE 'Agenda'
    FIELD FldCodigo AT (32 20 68 14) UNDERLINED MAXCHARS 10 AUTOSHIFT NUMERIC
    FIELD Fldnome AT (36 44 120 14) UNDERLINED MAXCHARS 10 AUTOSHIFT
    FIELD fldtelefone AT (40 68 116 14) UNDERLINED MAXCHARS 10 AUTOSHIFT
    LABEL Label1 'Codigo' AT (0 20)
    LABEL Label2 'Nome' AT (0 44)
    LABEL Label3 'Telefone' AT (0 68)
    BUTTON btvoltar '<<' AT (119 141 13 14)
    BUTTON btavancar '>>' AT (135 141 17 14)
    BUTTON btalterar 'Alter.' AT (29 121 26 14)
    BUTTON btnovo 'Novo' AT (1 121 25 14)
    BUTTON btgravar 'Gravar' AT (57 121 30 14)
    BUTTON btcancelar 'Cancel' AT (90 121 31 14)
    BUTTON btexcluir 'Excluir' AT (124 121 33 14)
    FIELD FldIdAtual AT (141 0 14 12) NONEDITABLE UNDERLINED MAXCHARS 10 AUTOSHIFT
  END;

procedure MostraDadosAgenda;
var
       temp:array[0..50] of char;
       temp_i:int32;
Begin
       //limpando o field que informar o numero do registro atual
       PsField.Settext(FldIdAtual,'');
       //verificando se existe algum registro no banco de dados
       if (PsDatabase.Recordcount(agendadb)=0)
       then exit;

       //resgatanto codigo,nome e telefone e adicionando nos respectivos fields
       temp_i:=PSDatabase.FieldUInt32(agendadb, agendacodigo);
       StrIToA(temp,temp_i);
       PSField.SetText(FldCodigo, temp);
       PSField.SetText(Fldnome,Psdatabase.FieldStringPtr(agendadb,agendanome));
       PSField.SetText(Fldtelefone,Psdatabase.FieldStringPtr(agendadb,agendatelefone));

       //resgatando o numero do registro atual
       temp_i:=PsDatabase.recno(agendadb);
       //adicionando o numero do registro atual no field
       stritoa(temp,temp_i);
       PsField.Settext(FldIdAtual,temp);
End;

procedure AtivaFields;
Begin
     //passa os 3 fields para editable =true
     PsField.Seteditable(Fldcodigo,true);
     PsField.Seteditable(FldNome,true);
     PsField.Seteditable(FldTelefone,true);
End;

procedure DesativaFields;
Begin
     //passa os 3 fields para editable =false
     PsField.Seteditable(Fldcodigo,false);
     PsField.Seteditable(FldNome,false);
     PsField.Seteditable(FldTelefone,false);
End;

procedure LimpaFields;
Begin
//limpa os 3 fields
      Psfield.settext(fldCodigo,'');
      Psfield.settext(fldNome,'');
      Psfield.settext(fldtelefone,'');
End;

procedure Form1Open;
begin
      PSForm.Draw;

      //limpo os fields
      LimpaFields;
      //limpo a variavel que indica se esta em modo de insercao ou edicao
      StatusAgenda:=#0;
      //limpando o field que mostra o id atual
      Psfield.Settext(FldIdAtual,'');
      //desativo os fields
      DesativaFields;

      //verifico se tenho informacoes no bd
      if (Psdatabase.recordcount(agendadb)>0)
      Then Begin//caso tenha
               //movimento para o primeiro registro
               PsDatabase.first(agendadb);
               //mostro os dados do primeiro registro
               MostraDadosAgenda;
      End;
end;

function Form1CustomEvent: Boolean;
begin
  Result := False;
end;

procedure btvoltarSelect;
begin
     limpafields;

     if (PsDatabase.recordcount(agendadb)=0)
     then exit;

     if (PsDatabase.Recno(agendadb)>0)
     Then PsDatabase.prior(agendadb);

     MostraDadosAgenda;
end;

procedure btavancarSelect;
begin
    limpafields;

    if (PsDatabase.recordcount(agendadb)=0)
    then exit;

    if ((PsDatabase.recno(agendadb)+1)<PsDatabase.recordcount(agendadb))
    Then PsDatabase.next(agendadb);

    MostraDadosAgenda;
end;

procedure btalterarSelect;
begin
     if (statusagenda<>#0)
     Then Begin
               //s posso alterar se estiver com status=#0 seno significa
               //que j estamos em modo de insercao (i) ou alterao(e)

               if (statusagenda='i')
               Then ShowMessage('O registro se encontra em estado de insero')
               else ShowMessage('O registro j se encontra em estado de alterao');

               exit;
     End;

     //caso no possua registro na base no tenho o que alterar
     if (PsDatabase.Recordcount(agendadb)=0)
     then exit;

     //alterando o registro atual
     MostraDadosAgenda;
     AtivaFields;
     PsField.SetEditable(Fldcodigo,false);
     PsField.SetFocused(Fldnome,true);
     statusagenda:='e';
end;

procedure btnovoSelect;
begin
     LimpaFields;
     AtivaFields;
     statusagenda:='i';
     Psfield.settext(fldidatual,'');
     Psfield.SetFocused(fldCodigo,true);
end;

procedure btgravarSelect;
var
temp,tempnome,temptelefone:array[0..50] of char;//ponteiro para uma string
tempi:int32;
procura:boolean;
begin
     if (statusagenda=#0)
     Then Begin
               Showmessage('Para gravar  necessrio estar em modo de insero ou edio');
               exit;
     End;

     //passando o valor do cdigo para uma variavel inteira
     PsField.Text(FldCodigo,temp,Psfield.TextLength(FldCodigo)+1);
     tempi:=StrAtoI(temp);//passando o valor para inteiro

     //procurando o cdigo no banco de dados e guarda o resultado na var. procura
     procura:=procuracodigoagenda(tempi);

     if (statusagenda='i')
     Then begin
               //se for insero no posso usar um cdigo que j exista
               if (procura=true)
               then Begin
                         Showmessage('No  possvel inserir um cdigo que j exista!');
                         exit;
               End;
               PSDatabase.append(agendadb)//passo para modo de insercao
     End
     Else Begin
               //para editar  necessario localizar o codigo no banco
               if (procura=false)
               then Begin
                         ShowMessage('Cdigo no localizado no banco de dados para ser editado');
                         exit;
               End;
               PSDatabase.edit(agendadb);//passo para modo de edicao
     End;

     //Guardando o valor dos fields (edits) em variaveis strings (vetor de caracteres)
     PsField.Text(FldCodigo,temp,Psfield.TextLength(FldCodigo)+1);
     tempi:=StrAtoI(temp);//passando o valor para inteiro
     PsField.Text(FldNome,tempnome,Psfield.TextLength(FldNome)+1);
     PsField.Text(FldTelefone,temptelefone,Psfield.TextLength(FldTelefone)+1);

     PSDatabase.SetFieldUInt32(AgendaDB,AgendaCodigo,tempi);//gravando um int32
     PsDatabase.SetFieldString(AgendaDb,AgendaNome,tempnome);//gravando uma string
     PsDatabase.SetFieldString(AgendaDb,AgendaTelefone,temptelefone);//gravando uma string
     PSDatabase.Post(agendadb);//gravo

     desativafields;
     limpafields;
     statusagenda:=#0;
     mostradadosagenda;
end;

procedure btcancelarSelect;
begin
     LimpaFields;
     DesativaFields;
     statusagenda:=#0;

     if (PsDatabase.RecordCount(Agendadb)>0)
     Then MostraDadosAgenda;
end;



procedure btexcluirSelect;
var
temp:array[0..32] of char;
tempi:int32;
resposta:integer;
begin
     if (PsDatabase.recordcount(agendadb)=0)
     then exit;

     if (statusagenda<>#0)
     Then Begin
               Showmessage('No possvel excluir um registro que esteja em insero ou edio');
               exit;
     End;

     resposta:=FrmAlert(AlertaConfirmaExclusao);

     if (resposta=1)
     Then exit;

      //para excluir  necessario localizar o codigo no banco
      PsField.Text(FldCodigo,temp,Psfield.TextLength(FldCodigo)+1);
      tempi:=StrAtoI(temp);//passando o valor para inteiro

      if (procuracodigoagenda(tempi)=False)
      then Begin
               ShowMessage('Cdigo no localizado no banco de dados');
               exit;
      End;

      PsDatabase.delete(Agendadb);
      limpafields;
      mostradadosagenda;
end;

function HandleEvent(var Event: EventType): Boolean;
begin
  PSApplication.Event := @Event;
  PSApplication.Handled := True;

  if not Form1CustomEvent then
    case Event.eType of
      ctlSelectEvent:
        with Event.ctlSelect do
          case controlID of
            btvoltar:
              btvoltarSelect;

            btavancar:
              btavancarSelect;

            btalterar:
              btalterarSelect;

            btnovo:
              btnovoSelect;

            btgravar:
              btgravarSelect;

            btcancelar:
              btcancelarSelect;

            btexcluir:
              btexcluirSelect;

            else
              PSApplication.Handled := False;
          end;

      frmOpenEvent:
        Form1Open;

      else
        PSApplication.Handled := False;
    end;

  Result := PSApplication.Handled;
end;

end.