unit UCadCidades;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastroPadrao, ImgList, DB, ComCtrls, ToolWin, StdCtrls, Mask,
  DBCtrls, Buttons, ExtCtrls;

type
  TFrmCadCidade = class(TCadastroPadrao)
    Label1: TLabel;
    DbeCodigo: TDBEdit;
    Label2: TLabel;
    DbeNome: TDBEdit;
    Label3: TLabel;
    DbeCodEstado: TDBEdit;
    SbLocEstado: TSpeedButton;
    PageControlCad: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label4: TLabel;
    DbmLocaisTuristicos: TDBMemo;
    DbmDadosHistoricos: TDBMemo;
    Panel1: TPanel;
    Panel2: TPanel;
    EdtSigla: TEdit;
    EdtNome: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PageControlCadDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure DsLocalDataChange(Sender: TObject; Field: TField);
    procedure TbLocalizarClick(Sender: TObject);
    procedure TbModificarClick(Sender: TObject);
    procedure TbNovoClick(Sender: TObject);
  private
    procedure PageControlDrawTab(Control: TCustomTabControl;
                                 TabIndex: Integer; const Rect: TRect; Active: Boolean;
                                 Color: TColor = clInfoBk;  ActiveColor: TColor = clNone;
                                 Vertical: Boolean = False );
  public

  end;

var
  FrmCadCidade: TFrmCadCidade;

implementation

uses UDMPrincipal, ULocalizaCidade;

{$R *.dfm}

procedure TFrmCadCidade.DsLocalDataChange(Sender: TObject; Field: TField);
begin
  inherited;
  if (DbeCodEstado.Text <> '') and
     DmPrincipal.CdsEstado.Locate('EST_CODIGO', DbeCodEstado.Text, []) then
  begin
    EdtSigla.Text := DmPrincipal.CdsEstadoEST_SIGLA.Text;
    EdtNome .Text := DmPrincipal.CdsEstadoEST_NOME .Text;
  end
  else
  begin
    EdtSigla.Text := '';
    EdtNome .Text := '';
  end;
end;

procedure TFrmCadCidade.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  DmPrincipal.CdsCidade.SaveToFile('c:\cidade.cds');
end;

procedure TFrmCadCidade.FormCreate(Sender: TObject);
begin
  inherited;
  DmPrincipal.CdsCidade.Close;

  if FileExists('c:\cidade.cds') then
     DmPrincipal.CdsCidade.LoadFromFile('c:\cidade.cds')
  else
     DmPrincipal.CdsCidade.CreateDataSet;

  DmPrincipal.CdsEstado.Close;

  if FileExists('c:\estado.cds') then
     DmPrincipal.CdsEstado.LoadFromFile('c:\estado.cds')
  else
  begin
    DmPrincipal.CdsEstado.CreateDataSet;
    DmPrincipal.CdsEstado.AppendRecord([1, 'Gois'     , 'GO']);
    DmPrincipal.CdsEstado.AppendRecord([2, 'So Paulo' , 'SP']); 
  end;

  DsLocal.DataSet := DmPrincipal.CdsCidade;
end;

procedure TFrmCadCidade.PageControlCadDrawTab(Control: TCustomTabControl;
  TabIndex: Integer; const Rect: TRect; Active: Boolean);
begin
  PageControlDrawTab(Control, TabIndex, Rect, Active, clSkyBlue);
end;

procedure TFrmCadCidade.PageControlDrawTab(Control: TCustomTabControl;
  TabIndex: Integer; const Rect: TRect; Active: Boolean;
  Color: TColor = clInfoBk;  ActiveColor: TColor = clNone;
  Vertical: Boolean = False );
var x,    y: Integer;
    Caption: String;
begin
  with TPageControl(Control).Canvas do
  begin

    if ActiveColor = clNone then   // para manter compatibilidade com a versao anterior desta funo.
       ActiveColor := Color;

    if Active then
    begin
      Brush.Color := ActiveColor;
      Pen.Color   := ActiveColor;
    end
    else
    begin
      Brush.Color := Color;
      Pen.Color   := Color;
    end;

    Rectangle(Rect.Left,Rect.Top,Rect.Right,Rect.Bottom);

    if TabIndex <> -1 then
    begin
      Caption := TTabSheet(TPageControl(Control).Pages[TabIndex]).Caption  ; // Pages
      Caption := StringReplace(Caption,'&','',[rfReplaceAll, rfIgnoreCase]);

      if Active then
         y := Rect.Top + ((Rect.Bottom - Rect.Top) - TextHeight(Caption) ) div 2
      else
         y := Rect.Top  + 3;

      x := Rect.Left + 6;


      TextOut(x, y,  Caption);
    end;
  end;
end;


procedure TFrmCadCidade.TbLocalizarClick(Sender: TObject);
begin
  FrmLocalizaCidade := TFrmLocalizaCidade.Create(Self);
  FrmLocalizaCidade.ShowModal;
  FrmLocalizaCidade.Free; 
end;

procedure TFrmCadCidade.TbModificarClick(Sender: TObject);
begin
  inherited;
  if DbeCodigo.CanFocus then
     DbeCodigo.SetFocus;
end;

procedure TFrmCadCidade.TbNovoClick(Sender: TObject);
begin
  inherited;
  if DbeCodigo.CanFocus then
     DbeCodigo.SetFocus;
end;

end.
