unit UCadastroPadrao;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ImgList, ToolWin, DB, JPEG, DBCtrls, StdCtrls;

type
  TCadastroPadrao = class(TForm)
    DsLocal: TDataSource;
    ToolBar1: TToolBar;
    ImgNormal: TImageList;
    ImgDisabled: TImageList;
    ImgHot: TImageList;
    TbNovo: TToolButton;
    TbLocalizar: TToolButton;
    TbSalvar: TToolButton;
    TbModificar: TToolButton;
    TbDeletar: TToolButton;
    TbImprimir: TToolButton;
    TbSair: TToolButton;
    TbAjuda: TToolButton;
    procedure DsLocalStateChange(Sender: TObject);
    procedure TbNovoClick(Sender: TObject);
    procedure TbSalvarClick(Sender: TObject);
    procedure TbModificarClick(Sender: TObject);
    procedure TbDeletarClick(Sender: TObject);
    procedure TbSairClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    function FormHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
    procedure TbAjudaClick(Sender: TObject);
  private
    function CapturarTela(BitMap: Boolean = True; Largura: Integer = 2; ControleAtivo : String = ''): String;
  public
  end;

var
  CadastroPadrao: TCadastroPadrao;

implementation

{$R *.dfm}

procedure TCadastroPadrao.DsLocalStateChange(Sender: TObject);
begin
  if DsLocal.DataSet = nil then
     Exit;

  TbNovo     .Enabled := not (DsLocal.State in [dsInsert, dsEdit]);
  TbLocalizar.Enabled := not (DsLocal.State in [dsInsert, dsEdit]);
  TbSalvar   .Enabled :=     (DsLocal.State in [dsInsert, dsEdit]);
  TbModificar.Enabled := (not DsLocal.DataSet.IsEmpty) and (not (DsLocal.State in [dsInsert, dsEdit]));
  TbDeletar  .Enabled := (not DsLocal.DataSet.IsEmpty) and (not (DsLocal.State in [dsInsert, dsEdit]));
  TbImprimir .Enabled := not DsLocal.DataSet.IsEmpty;
end;

function TCadastroPadrao.FormHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  if Data = 0 then
     ShowMessage('No existe um tpico da ajuda para este item')
  else
     HtmlHelp(Self.Handle, 'Borcon.chm', $000F, Data   );

  CallHelp := False;
  Result   := True ;
end;

procedure TCadastroPadrao.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (ssCtrl in Shift) then
  begin
    if (Key = VK_NUMPAD0) then
       CapturarTela(True, 0)
    else
    if (Key = VK_NUMPAD1) then
       CapturarTela(True, 1)
   else
   if (Key = VK_NUMPAD2) then
       CapturarTela(True, 2)
   else
   if (Key = VK_NUMPAD4) then
      CapturarTela(True, 0, ActiveControl.Name)
   else
   if (Key = VK_NUMPAD5) then
      CapturarTela(True, 1, ActiveControl.Name)
  else
  if (Key = VK_NUMPAD6) then
      CapturarTela(True, 2, ActiveControl.Name)
  end
  else
  if key = VK_UP then
  begin
    if (ActiveControl is TDBEdit        ) or
       (ActiveControl is TEdit          ) or
       (ActiveControl is TDBMemo        ) or
       ( (ActiveControl is TComboBox    ) and ( not TComboBox(ActiveControl).DroppedDown )) then
    begin
      Key := VK_NONAME;
      SelectNext(ActiveControl, False, True);

      if (ActiveControl is TComboBox) and
         (TComboBox(ActiveControl).ItemIndex <= 0) and
         (Trim(TComboBox(ActiveControl).Items.Strings[0]) = '')  then
        SendMessage(TComboBox(Screen.ActiveForm.ActiveControl).Handle,CB_SHOWDROPDOWN,-1,0);

    end;

  end
  else
  begin
    if (     (Key = VK_RETURN)                                           ) and
       ( ActiveControl <> nil)  and (ActiveControl.ClassName <> 'TDBGrid') and
       ( ActiveControl.ClassName <> 'TDBGridInplaceEdit'                 ) then
    begin
      Key := VK_NONAME;
      SelectNext(ActiveControl, True, True);

      if ActiveControl is TDBRadioGroup then
      begin

        if (TDBRadioGroup(ActiveControl).ItemIndex  < 0 ) and
           (TDBRadioGroup(ActiveControl).Items.Count > 0) then
           TDBRadioGroup(ActiveControl).ItemIndex := 0;

        keybd_event(VK_RETURN, 0, 0, 0);

      end
      else
      if ActiveControl is TComboBox then
      begin
        if (ActiveControl is TComboBox) and
           (TComboBox(ActiveControl).ItemIndex <= 0) and
           (Trim(TComboBox(ActiveControl).Items.Strings[0]) = '')  then
          SendMessage(TComboBox(Screen.ActiveForm.ActiveControl).Handle,CB_SHOWDROPDOWN,-1,0);

      end;

    end;

  end;

end;

function TCadastroPadrao.CapturarTela(BitMap: Boolean = True; Largura: Integer = 2; ControleAtivo : String = ''): String;
type TFormato = (fmJpeg, fmBmp );
var Origem         ,
    Destino        : TRect  ;
    DC             : HDc    ;
    Canv           : TCanvas;
    Bmp            : TBitMap;
    Jpg            : TJPEGImage;
    Pasta          ,   
    NomedoArquivo  : String;
    Formato        : TFormato;
    i              : Integer ;
    ExcederLarg    : Integer ;
    ExcederAlt     : Integer ;
    MyActiveControl: TWinControl;
    x1             ,
    y1             ,
    x2             ,
    y2             : Integer;
    P              : TPoint ;
begin

  ForceDirectories('C:\Borcon');

  ExcederLarg := 0;
  ExcederAlt  := 0;

  MyActiveControl := nil;

  case Largura of
    0: ExcederLarg := 000;
    1: ExcederLarg := 100;
    2: begin
         ExcederLarg := 100;
         ExcederAlt  := 100;
       end;
  end;

  if BitMap then
     Formato := fmBmp
  else
     Formato := fmJpeg;

  Bmp         := TBitMap.Create;

  if ControleAtivo = '' then
  begin
    Bmp.Height  := Screen.ActiveForm.Height+ ExcederAlt ;
    Bmp.Width   := Screen.ActiveForm.Width + ExcederLarg;
  end
  else
  begin
    MyActiveControl := nil;

    for i := 0 to Screen.ActiveForm.ComponentCount - 1 do
    begin

      if (Screen.ActiveForm.Components[i].Name = ControleAtivo) then
      begin
        MyActiveControl := TWinControl(Screen.ActiveForm.Components[i]);
        P := MyActiveControl.ClientToScreen( Point(0,0) );
        Break;
      end;

    end;

    if MyActiveControl = nil then
       MyActiveControl := Screen.ActiveForm;


    Bmp.Height  := MyActiveControl.Height+ ExcederAlt ;
    Bmp.Width   := MyActiveControl.Width + ExcederLarg;
  end;

  Bmp.Canvas.Brush.Color := clWhite;
  Bmp.Canvas.Pen  .Color := clWhite;

  Bmp.Canvas.FillRect(Rect(0,0,Bmp.Width, Bmp.Height));

  DC          := GetWindowDC( Screen.ActiveForm.Handle );
  Canv        := TCanvas.Create;
  Canv.Handle := DC;

  if ControleAtivo = '' then
  begin
    Origem      := Rect(000, 000, Screen.Width      ,Screen.Height);

    case Largura of
      0: Destino := Rect(000,   0, Screen.Width + 000, Screen.Height     );
      1: Destino := Rect(050,   0, Screen.Width + 050, Screen.Height     );
      2: Destino := Rect(050, 050, Screen.Width + 050, Screen.Height+ 050);
    end;

  end
  else
  begin

    if MyActiveControl = nil then
       MyActiveControl := Screen.ActiveForm;

    x1 := P.X - Screen.ActiveForm.Left;
    y1 := P.Y - Screen.ActiveForm.Top ;
    x2 := x1  + MyActiveControl.Width ;
    y2 := y1  + MyActiveControl.Height;

    Origem      := Rect(x1, y1, x2, y2);

    case Largura of
      0: Destino := Rect(000,   0, MyActiveControl.Width + 000, MyActiveControl.Height      );
      1: Destino := Rect(050,   0, MyActiveControl.Width + 050, MyActiveControl.Height      );
      2: Destino := Rect(050, 050, MyActiveControl.Width + 050, MyActiveControl.Height + 050);
    end;

  end;

  Bmp.Canvas.CopyRect( Destino, Canv, Origem );

  Bmp.Canvas.Brush.Color := clWhite;
  Bmp.Canvas.Pen  .Color := clWhite;

  case Largura of
    0: ;
    1: begin
         Bmp.Canvas.FillRect(Rect(Bmp.Width - 50, 0              , Bmp.Width   , Bmp.Height));
       end;
    2: begin
         Bmp.Canvas.FillRect(Rect(Bmp.Width - 50, 0              , Bmp.Width   , Bmp.Height));
         Bmp.Canvas.FillRect(Rect(            50, Bmp.Height - 50, Bmp.Width-50, Bmp.Height));
       end;
  end;

  Jpg:=TJPEGImage.Create;
  Jpg.Assign(Bmp);

  NomedoArquivo := Screen.ActiveForm.Name+'_'+FormatFloat('000', Screen.ActiveForm.Tag);

  NomedoArquivo := InputBox('Nome do arquivo', 'Nome do arquivo (\ para criar pasta):', NomedoArquivo );
  Pasta := 'C:\Borcon\Documentacao\';

  if (NomedoArquivo <> '') and (NomedoArquivo[1] = '\') then // ir criar uma subpasta para o arquivo...
  begin // por se tratar de mltiplas telas
    Pasta := Pasta + Screen.ActiveForm.Name;
    ForceDirectories(Pasta);
  end;

  NomedoArquivo := Pasta + NomedoArquivo;

  try
    case Formato of
         fmJpeg: begin
                 NomedoArquivo := NomedoArquivo+'.jpeg';
                 Jpg.SaveToFile(NomedoArquivo);
                 end;
         fmBmp : begin
                 NomedoArquivo := NomedoArquivo+'.bmp';
                 Bmp.SaveToFile(NomedoArquivo);
                 end;
    end;
    ShowMessage('Tela capturada com sucesso'      );
  except
    ShowMessage('No foi possvel capturar a tela');
  end;

  Result := NomedoArquivo;
end;


procedure TCadastroPadrao.TbAjudaClick(Sender: TObject);
begin
  HtmlHelp(Self.Handle, 'Borcon.chm', $000F, StrToInt(IntToStr(Self.Tag)+'000') );
end;

procedure TCadastroPadrao.TbDeletarClick(Sender: TObject);
begin
  DsLocal.DataSet.Delete;
end;

procedure TCadastroPadrao.TbModificarClick(Sender: TObject);
begin
  DsLocal.DataSet.Edit;
end;

procedure TCadastroPadrao.TbNovoClick(Sender: TObject);
begin
  DsLocal.DataSet.Append;
end;

procedure TCadastroPadrao.TbSairClick(Sender: TObject);
begin
  Self.Close;
end;

procedure TCadastroPadrao.TbSalvarClick(Sender: TObject);
begin
  DsLocal.DataSet.Post;
end;

end.
