unit WebControl2;
// To create a more advanced Web Control that supports live data at
// design time, see instructions in the readme file located in the
// 'BDS\4.0\Source\DotNet\dbwebcontrols' directory

interface

uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel;

type
  /// <summary>
  /// Summary description for MyWebControl2.
  /// </summary>
  [DefaultProperty('Text'),
   ToolboxData('<{0}:EasyEmail runat=server></{0}:EasyEmail>')]
  EasyEmail = class(System.Web.UI.WebControls.WebControl)
  strict private
    FText: String;
    FTbxNomeFrom: TextBox;
    FTbxEmailFrom: TextBox;
    FTbxPara: TextBox;
    FTbxAssunto: TextBox;
    FTbxMensagem: TextBox;
    FBtnSend: Button;
  strict protected
    // override RenderContents(..) when you inherit from Web.UI.WebControls.WebControl
    procedure RenderContents(Output: HtmlTextWriter); override;
    procedure CreateChildControls;override;
   // override Render(..) when you inherit from Web.UI.WebControls.Control
   // procedure Render(Output: HtmlTextWriter); override;
  public
    constructor Create;
  published
    [Bindable(true),
     Category('Appearance'),
     DefaultValue('')]
    property Text: string read FText write FText;
  end;

implementation

uses
  System.Web.Mail;

/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// </summary>
constructor EasyEmail.Create;
begin
  inherited;
end;

/// <summary>
/// Render this control to the output parameter specified, preserving
/// cosmetic attribute output generation inherited from standard WebControl.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure EasyEmail.CreateChildControls;
begin
  inherited;
  FTbxNomeFrom := TextBox.Create;
  Controls.Add(FTbxNomeFrom);
  //
  FTbxEmailFrom := TextBox.Create;
  Controls.Add(FTbxEmailFrom);
  //
  FTbxPara := TextBox.Create;
  Controls.Add(FTbxPara);
  //
  FTbxAssunto:= TextBox.Create;
  Controls.Add(FTbxAssunto);
  //
  FTbxMensagem:= TextBox.Create;
  FTbxMensagem.TextMode := TextBoxMode.MultiLine;
  FTbxMensagem.Height := 100;
  FTbxMensagem.Width  := 500;
  Controls.Add(FTbxMensagem);
  //
  FBtnSend := Button.Create;
  FBtnSend.Text := 'Transmitir';
  Controls.Add(FBtnSend);
end;

procedure EasyEmail.RenderContents(Output: HtmlTextWriter);
begin
  EnsureChildControls;
  Output.RenderBeginTag(HtmlTextWriterTag.Table);
  //Nome
  Output.RenderBeginTag(HtmlTextWriterTag.Tr);
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  Output.Write('Nome: ');
  Output.RenderEndTag;
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  FtbxNomeFrom.RenderControl(OutPut);
  Output.RenderEndTag;
  Output.RenderEndTag;
  //
  //Email
  Output.RenderBeginTag(HtmlTextWriterTag.Tr);
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  Output.Write('De: ');
  Output.RenderEndTag;
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  FtbxEmailFrom.RenderControl(OutPut);
  Output.RenderEndTag;
  Output.RenderEndTag;
  //
  //Para
  Output.RenderBeginTag(HtmlTextWriterTag.Tr);
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  Output.Write('Para: ');
  Output.RenderEndTag;
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  FtbxPara.RenderControl(OutPut);
  Output.RenderEndTag;
  Output.RenderEndTag;
  //
  //Assunto
  Output.RenderBeginTag(HtmlTextWriterTag.Tr);
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  Output.Write('Assunto: ');
  Output.RenderEndTag;
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  FtbxAssunto.RenderControl(OutPut);
  Output.RenderEndTag;
  Output.RenderEndTag;
  //
  //Mensagem
  Output.RenderBeginTag(HtmlTextWriterTag.Tr);
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  Output.Write('Mensagem: ');
  Output.RenderEndTag;
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  FtbxMensagem.RenderControl(OutPut);
  Output.RenderEndTag;
  Output.RenderEndTag;
  //
  //Botao Enviar
  Output.RenderBeginTag(HtmlTextWriterTag.Tr);
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  FBtnSend.RenderControl(OutPut);
  Output.RenderEndTag;
  //
  Output.RenderBeginTag(HtmlTextWriterTag.Td);
  Output.RenderEndTag;
  Output.RenderEndTag;
  //
  Output.RenderEndTag;
end;

{$REGION 'Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure MyWebControl2.Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(* *)
{$ENDREGION}

end.
