unit WebControl2;
// To create a more advanced Web Control that supports live data at
// design time, see instructions in the readme file located in the
// 'BDS\4.0\Source\DotNet\dbwebcontrols' directory

interface

uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel,
  System.Web.UI.Design,
  System.ComponentModel.Design, System.Drawing;

type
  /// <summary>
  /// Summary description for MyWebControl2.
  /// </summary>
  TextActionList = class(DesignerActionList)
  private
    FBackColor: Color;
  published
  public
    procedure set_Css(const Value: string);
    function GetCss: string;
    procedure set_BackColor(const Value: Color);
    function GetBackColor: Color;
  published
    function GetSortedActionItems: DesignerActionItemCollection;override;
    property Css: string read GetCss write set_Css;
    property BackColor: Color read GetBackColor write set_BackColor;
  end;

  TextBoxControlDesigner = class(System.Web.UI.Design.ControlDesigner)
  strict private
    FActions: DesignerActionListCollection;
  public
    function Get_ActionLists: DesignerActionListCollection;override;
  end;

  [Designer(TypeOf(TextBoxControlDesigner)),
   DefaultProperty('Text'),
   ToolboxData('<{0}:TextBoxSmart runat=server></{0}:TextBoxSmart>')]
  TextBoxSmart = class(System.Web.UI.WebControls.TextBox)
  strict private
    FText: String;
  strict protected
    // override RenderContents(..) when you inherit from Web.UI.WebControls.WebControl 
    procedure RenderContents(Output: HtmlTextWriter); override;
    
   // override Render(..) when you inherit from Web.UI.WebControls.Control
   // procedure Render(Output: HtmlTextWriter); override;
  public
    constructor Create;
  published
    [Bindable(true),
     Category('Appearance'),
     DefaultValue('')]
    property Text: string read FText write FText;
  end;

implementation

/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// </summary>
constructor TextBoxSmart.Create;
begin
  inherited;
end;

/// <summary>
/// Render this control to the output parameter specified, preserving
/// cosmetic attribute output generation inherited from standard WebControl.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure TextBoxSmart.RenderContents(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;

{$REGION 'Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure MyWebControl2.Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(* *)
{$ENDREGION}

{ TextBoxControlDesigner }

function TextBoxControlDesigner.Get_ActionLists: DesignerActionListCollection;
var
  Item: TextActionList;
begin
  if not Assigned(FActions) then
  begin
    FActions := DesignerActionListCollection.Create;
    Item := TextActionList.Create(Component);
    FActions.Add(Item);
  end;
  result := FActions;
end;

{ TextActionList }

function TextActionList.GetBackColor: Color;
begin
  result :=  TextBoxSmart(Component).BackColor;
end;

function TextActionList.GetCss: string;
begin
  result := TextBoxSmart(Component).CssClass;
end;

function TextActionList.GetSortedActionItems: DesignerActionItemCollection;
var
  Items: DesignerActionItemCollection;
  Header: DesignerActionHeaderItem;
  TextItem: DesignerActionTextItem;
  PropItemCSS: DesignerActionPropertyItem;
  PropItemBackColor: DesignerActionPropertyItem;
begin
  Items :=DesignerActionItemCollection.Create;
  Header := DesignerActionHeaderItem.Create('BorCon 2007');
  TextItem := DesignerActionTextItem.Create('Meu Control Designer','');
  PropItemCSS := DesignerActionPropertyItem.Create('Css','Class CSS:');
  PropItemBackColor := DesignerActionPropertyItem.Create('BackColor','Cor de Fundo:');
  Items.Add(Header);
  Items.Add(TextItem);
  Items.Add(PropItemCSS);
  Items.Add(PropItemBackColor);
  result := Items;
end;

procedure TextActionList.set_BackColor(const Value: Color);
begin
  TextBoxSmart(Component).BackColor := Value;
end;

procedure TextActionList.set_Css(const Value: string);
begin
  TextBoxSmart(Component).cssClass := Value;
end;

end.
