unit WebControl1;
// To create a more advanced Web Control that supports live data at
// design time, see instructions in the readme file located in the
// 'BDS\4.0\Source\DotNet\dbwebcontrols' directory

interface

uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel;

type
  /// <summary>
  /// Summary description for MyWebControl2.
  /// </summary>
  ///
  [DefaultProperty('Text'),
   ToolboxData('<{0}:TextBoxControlState runat=server></{0}:TextBoxControlState>')]
  TextBoxControlState = class(System.Web.UI.WebControls.TextBox)
  strict private
    FFocused: boolean;
  strict protected
    // override RenderContents(..) when you inherit from Web.UI.WebControls.WebControl 
    procedure RenderContents(Output: HtmlTextWriter); override;

   // override Render(..) when you inherit from Web.UI.WebControls.Control
   // procedure Render(Output: HtmlTextWriter); override;
   procedure OnPreRender(e: EventArgs);override;
  public
    constructor Create;
  published
    [Bindable(true),
     Category('Appearance'),
     DefaultValue(''), Description('Joga o foco!')]
    property Focused: boolean read FFocused write FFocused;

    //Control State
    function SaveControlState: &Object;override;
    procedure LoadControlState(SavedState: &Object);override;
    procedure OnInit(e: EventArgs);override;
  end;


implementation

/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// </summary>
constructor TextBoxControlState.Create;
begin
  inherited;
end;

/// <summary>
/// Render this control to the output parameter specified, preserving
/// cosmetic attribute output generation inherited from standard WebControl.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure TextBoxControlState.LoadControlState(SavedState: &Object);
begin
  inherited;
  FFocused := boolean(SavedState)
end;

procedure TextBoxControlState.OnInit(e: EventArgs);
begin
  inherited;
  Page.RegisterRequiresControlState(self);
end;

procedure TextBoxControlState.OnPreRender(e: EventArgs);
begin
  inherited;
  if FFocused then  
    Page.RegisterStartupScript('','<script>ctl01.'+ ID + '.focus();</script>' );
end;

procedure TextBoxControlState.RenderContents(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;

{$AUTOBOX ON}
function TextBoxControlState.SaveControlState: &Object;
begin
  result := FFocused;
end;

{$REGION 'Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure MyWebControl2.Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(* *)
{$ENDREGION}

end.
