unit WebControl2;
// To create a more advanced Web Control that supports live data at
// design time, see instructions in the readme file located in the
// 'BDS\4.0\Source\DotNet\dbwebcontrols' directory

interface

uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel,
  System.Collections;

type
  /// <summary>
  /// Summary description for MyWebControl2.
  /// </summary>
  [DefaultProperty('Text'),
   ToolboxData('<{0}:DataViewList runat=server></{0}:DataViewList>')]
  DataViewList = class(System.Web.UI.WebControls.DataBoundControl)
  strict private
    FDataTextField: string;
    FBoxText: TextBox;
  protected
    // override RenderContents(..) when you inherit from Web.UI.WebControls.WebControl
    procedure RenderContents(Output: HtmlTextWriter); override;
    procedure OnDataSourceViewSelectCallback(retrievedData: IEnumerable);
  published

   // override Render(..) when you inherit from Web.UI.WebControls.Control
   procedure Render(Output: HtmlTextWriter); override;
  public
    constructor Create;
    procedure set_DataTextField(const Value: string);
    function get_DataTextField: string;
  published
    [Bindable(true),
     Category('Appearance'),
     DefaultValue('')]

    //DATABINDING
    property DataTextField: string read get_DataTextField write set_DataTextField;
    procedure PerformSelect;override;
    procedure PerformDataBinding(data: IEnumerable);override;
  end;

implementation

/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// </summary>
constructor DataViewList.Create;
begin
  inherited;
end;

/// <summary>
/// Render this control to the output parameter specified, preserving
/// cosmetic attribute output generation inherited from standard WebControl.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
function DataViewList.get_DataTextField: string;
begin
  result := FDataTextField;
end;

procedure DataViewList.OnDataSourceViewSelectCallback(
  retrievedData: IEnumerable);
begin
  //isso  necessrio pois em fonte "IDataSource" este
  //evento deve acontecer depois do GetData
  if IsBoundUsingDataSourceID then
    OnDataBinding(EventArgs.Empty);
  PerformDataBinding(retrievedData) //dados retornados no
  //retrivedata
end;

procedure DataViewList.PerformDataBinding(Data: System.Collections.IEnumerable);
var
  Item: &Object;
begin
  inherited;
  if Assigned(Data) then
    for Item in Data do
    begin
      FBoxText := TextBox.Create;
      FBoxText.Text :=
        DataBinder.GetPropertyValue(Item, FDataTextField).ToString;
      Controls.Add(FBoxText);
    end;
end;

procedure DataViewList.PerformSelect;
begin
  inherited;
  if not IsBoundUsingDataSourceID Then
    OnDataBinding(EventArgs.Empty); //caso DataSource este
    //evento deve acontecer antes do GetData.
  //o select traz os dados
  GetData.Select(CreateDataSourceSelectArguments, //argumento vazio
  //DataSourceSelectArguments.Empty.
  //pode ser usado em situaes de paginacao com DataSourceCapabilities.Page
      OnDataSourceViewSelectCallback); //olha o delegate,
      //como o selec  assincrono, avisa ao controle que o procedimento
      //encerrou-se, e os dados retornados no parametro do mesmo.
  //indicam que o procedimento de binding foi concludo
  RequiresDataBinding := false;
  MarkAsDataBound;
  //Invoca o evento
  OnDataBound(EventArgs.Empty);
end;

procedure DataViewList.Render(Output: HtmlTextWriter);
begin
  inherited;
end;

procedure DataViewList.RenderContents(Output: HtmlTextWriter);
begin
  inherited;
end;

procedure DataViewList.set_DataTextField(const Value: string);
begin
  FDataTextField := Value;
end;

{$REGION 'Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure MyWebControl2.Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(* *)
{$ENDREGION}

end.
