unit WebControl2;
// To create a more advanced Web Control that supports live data at
// design time, see instructions in the readme file located in the
// 'BDS\4.0\Source\DotNet\dbwebcontrols' directory

interface

uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel, System.Collections.Specialized;

type
  /// <summary>
  /// Summary description for MyWebControl2.
  /// </summary>
  [DefaultProperty('Text'),
   ToolboxData('<{0}:TextBoxPostBackData runat=server></{0}:TextBoxPostBackData>')]
  TextBoxPostBackData = class
    (System.Web.UI.WebControls.TextBox, IPostBackDataHandler)
  strict private
    FOnCalc: EventHandler;
    // override RenderContents(..) when you inherit from Web.UI.WebControls.WebControl
  protected
    procedure RenderContents(Output: HtmlTextWriter); override;
  published

   // override Render(..) when you inherit from Web.UI.WebControls.Control
   // procedure Render(Output: HtmlTextWriter); override;
  public
    constructor Create;
  //PostBack
    function LoadPostData(postDataKey: string;
      postCollection: NameValueCollection): Boolean;
    procedure set_OnCalc(const Value: EventHandler);
  published
    property OnCalc: EventHandler read FOnCalc write set_OnCalc;
  end;

implementation

/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// </summary>
constructor TextBoxPostBackData.Create;
begin
  inherited;
end;
/// <summary>
/// Render this control to the output parameter specified, preserving
/// cosmetic attribute output generation inherited from standard WebControl.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
function TextBoxPostBackData.LoadPostData
(postDataKey: string;
  postCollection: NameValueCollection): Boolean;
begin
  Text := Convert.ToString(Convert.ToInt32(postCollection[UniqueID].ToString) * 2);
  OnCalc(Self, EventArgs.Empty);
  result := False;  //meu estado nao mudou!
end;

procedure TextBoxPostBackData.RenderContents(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;

procedure TextBoxPostBackData.set_OnCalc(const Value: EventHandler);
begin
  FOnCalc := Value;
end;

{$REGION 'Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure MyWebControl2.Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(* *)
{$ENDREGION}

end.
