unit WebControl2;
// To create a more advanced Web Control that supports live data at
// design time, see instructions in the readme file located in the
// 'BDS\4.0\Source\DotNet\dbwebcontrols' directory

interface

uses
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel, System.Drawing.Design;

type
  /// <summary>
  /// Summary description for MyWebControl2.
  /// </summary>

  PropertyEditorLabel = class(System.Drawing.Design.UITypeEditor)
    function EditValue
      (Context: System.ComponentModel.ITypeDescriptorContext;
        Provider: System.IServiceProvider;
          Value: &Object): &Object;override;
    //
    function GetEditStyle
      (Context: System.ComponentModel.ITypeDescriptorContext):
        System.Drawing.Design.UITypeEditorEditStyle;override;
  end;

  [DefaultProperty('Text'),
   ToolboxData('<{0}:LabelEx runat=server></{0}:LabelEx>')]
  LabelEx = class(System.Web.UI.WebControls.Label)
  strict private
    FText: String;
  strict
  private
    FCustomText: string; protected
    // override RenderContents(..) when you inherit from Web.UI.WebControls.WebControl 
    procedure RenderContents(Output: HtmlTextWriter); override;
  published
    
   // override Render(..) when you inherit from Web.UI.WebControls.Control
   // procedure Render(Output: HtmlTextWriter); override;
  public
    constructor Create;
    procedure set_CustomText(const Value: string);
  published
    [Bindable(true),
     Category('Appearance'),
     DefaultValue('')]
    property Text: string read FText write FText;
    //
    [EditorAttribute(TypeOf(PropertyEditorLabel), TypeOf(System.Drawing.Design.UITypeEditor))] 
    property CustomText: string read FCustomText write set_CustomText;
  end;

implementation

uses
  System.Windows.Forms;

/// <summary>
/// Define a public parameterless constructor needed by web controls.
/// </summary>
constructor LabelEx.Create;
begin
  inherited;
end;

/// <summary>
/// Render this control to the output parameter specified, preserving
/// cosmetic attribute output generation inherited from standard WebControl.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure LabelEx.RenderContents(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;

procedure LabelEx.set_CustomText(const Value: string);
begin
  FCustomText := Value;
end;

{$REGION 'Render override'}
(*
/// <summary>
/// Render this control to the output parameter specified.
/// </summary>
/// <param name="output"> The HTML writer to write out to </param>
procedure MyWebControl2.Render(Output: HtmlTextWriter);
begin
  Output.Write(Text);
end;
(* *)
{$ENDREGION}

{ PropertyEditorLabel }

function PropertyEditorLabel.EditValue(
  Context: System.ComponentModel.ITypeDescriptorContext;
  Provider: System.IServiceProvider; Value: &Object): &Object;
var
  strMsg: string;
begin
  strMsg := 'My Property Editor';
  MessageBox.Show(strMsg);
  result := strMsg;
end;

function PropertyEditorLabel.GetEditStyle(
  Context: System.ComponentModel.ITypeDescriptorContext): System.Drawing.Design.UITypeEditorEditStyle;
begin
  result := UITypeEditorEditStyle.Modal;
end;

end.
