unit Modelo.Calendario;

interface

uses
  SysUtils, Classes, FMTBcd, DBClient, Provider, DB, SqlExpr;

type
  TdtmdlAgenda = class(TDataModule)
    sqldtstAgenda: TSQLDataSet;
    dtstprvdrAgenda: TDataSetProvider;
    clntdtstAgenda: TClientDataSet;
    clntdtstAgendaCOD_AGENDA: TIntegerField;
    clntdtstAgendaCOR_ROTULO: TIntegerField;
    clntdtstAgendaDATA_RECORRENCIA: TSQLTimeStampField;
    clntdtstAgendaESTADO: TIntegerField;
    clntdtstAgendaFINAL_ATUAL: TIntegerField;
    clntdtstAgendaID: TIntegerField;
    clntdtstAgendaID_PAI: TIntegerField;
    clntdtstAgendaID_RECORRENCIA: TIntegerField;
    clntdtstAgendaID_RECURSO: TIntegerField;
    clntdtstAgendaINFO_RECORRENCIA: TBlobField;
    clntdtstAgendaINICIO: TSQLTimeStampField;
    clntdtstAgendaINICIO_ATUAL: TIntegerField;
    clntdtstAgendaLOCALIZACAO: TStringField;
    clntdtstAgendaMENSAGEM: TStringField;
    clntdtstAgendaMINUTOS_AVISO: TIntegerField;
    clntdtstAgendaOPCAO: TIntegerField;
    clntdtstAgendaROTULO: TStringField;
    clntdtstAgendaTERMINO: TSQLTimeStampField;
    clntdtstAgendaTIPO_EVENTO: TIntegerField;
    procedure clntdtstAgendaReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure clntdtstAgendaNewRecord(DataSet: TDataSet);
    procedure clntdtstAgendaAfterDelete(DataSet: TDataSet);
    procedure clntdtstAgendaAfterPost(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Salvar;
  end;

var
  dtmdlAgenda: TdtmdlAgenda;

implementation

uses Modelo.Conexao, Dialogs;

{$R *.dfm}

procedure TdtmdlAgenda.clntdtstAgendaAfterDelete(DataSet: TDataSet);
begin
  Salvar;
end;

procedure TdtmdlAgenda.clntdtstAgendaAfterPost(DataSet: TDataSet);
begin
  Salvar;
end;

procedure TdtmdlAgenda.clntdtstAgendaNewRecord(DataSet: TDataSet);
begin
  clntdtstAgendaCOD_AGENDA.Value := dtmdlConexao.GerarCodigoAutomovel;
end;

procedure TdtmdlAgenda.clntdtstAgendaReconcileError(
  DataSet: TCustomClientDataSet; E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  MessageDlg(E.Message, mtWarning, [mbOK], 0);
end;

procedure TdtmdlAgenda.Salvar;
begin
  clntdtstAgenda.ApplyUpdates(0);
end;

end.
