unit Modelo.Cliente;

interface

uses
  SysUtils, Classes, FMTBcd, DBClient, Provider, DB, SqlExpr;

type
  TdtmdlCliente = class(TDataModule)
    sqldtstListaCliente: TSQLDataSet;
    dtstprvdrListaCliente: TDataSetProvider;
    clntdtstListaCliente: TClientDataSet;
    clntdtstListaClienteCOD_CLIENTE: TIntegerField;
    clntdtstListaClienteDES_CLIENTE: TStringField;
    clntdtstListaClienteDES_ENDERECO: TStringField;
    clntdtstListaClienteDES_CIDADE: TStringField;
    clntdtstListaClienteDES_ESTADO: TStringField;
    clntdtstListaClienteDAT_CADASTRO: TDateField;
    clntdtstListaClienteDES_EMAIL: TStringField;
    clntdtstListaClienteBLN_DAR_CREDITO: TIntegerField;
    clntdtstListaClienteDES_TELEFONE: TStringField;
    procedure clntdtstListaClienteReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure clntdtstListaClienteNewRecord(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dtmdlCliente: TdtmdlCliente;

implementation

uses Modelo.Conexao, Dialogs;

{$R *.dfm}

procedure TdtmdlCliente.clntdtstListaClienteNewRecord(DataSet: TDataSet);
begin
  clntdtstListaClienteCOD_CLIENTE.Value := dtmdlConexao.GerarCodigoCliente;
end;

procedure TdtmdlCliente.clntdtstListaClienteReconcileError(
  DataSet: TCustomClientDataSet; E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  MessageDlg(E.Message, mtWarning, [mbOK], 0);
end;

end.
